/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class Recv<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "Recv";
    private Output<T> tensor;

    public static <T extends TType> Recv<T> create(Scope scope, DataType<T> tensorType, String tensorName, String sendDevice, Long sendDeviceIncarnation, String recvDevice, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("tensor_type", tensorType);
        opBuilder.setAttr("tensor_name", tensorName);
        opBuilder.setAttr("send_device", sendDevice);
        opBuilder.setAttr("send_device_incarnation", sendDeviceIncarnation);
        opBuilder.setAttr("recv_device", recvDevice);
        if (options != null) {
            for (Options opts : options) {
                if (opts.clientTerminated == null) continue;
                opBuilder.setAttr("client_terminated", opts.clientTerminated);
            }
        }
        return new Recv<T>(opBuilder.build());
    }

    public static Options clientTerminated(Boolean clientTerminated) {
        return new Options().clientTerminated(clientTerminated);
    }

    public Output<T> tensor() {
        return this.tensor;
    }

    @Override
    public Output<T> asOutput() {
        return this.tensor;
    }

    private Recv(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.tensor = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean clientTerminated;

        public Options clientTerminated(Boolean clientTerminated) {
            this.clientTerminated = clientTerminated;
            return this;
        }

        private Options() {
        }
    }
}

