/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import com.google.protobuf.InvalidProtocolBufferException;
import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.NativeLibrary;
import org.tensorflow.exceptions.TensorFlowException;
import org.tensorflow.internal.c_api.TF_Buffer;
import org.tensorflow.internal.c_api.TF_Library;
import org.tensorflow.internal.c_api.TF_Status;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.proto.framework.OpList;

public final class TensorFlow {
    public static String version() {
        return tensorflow.TF_Version().getString();
    }

    public static OpList registeredOpList() {
        TF_Buffer buf = tensorflow.TF_GetAllOpList();
        try {
            OpList opList = OpList.parseFrom(buf.dataAsByteBuffer());
            return opList;
        }
        catch (InvalidProtocolBufferException e) {
            throw new TensorFlowException("Cannot parse OpList protocol buffer", e);
        }
        finally {
            tensorflow.TF_DeleteBuffer(buf);
        }
    }

    public static OpList loadLibrary(String filename) {
        TF_Library h = null;
        try {
            h = TensorFlow.libraryLoad(filename);
        }
        catch (RuntimeException e) {
            throw new UnsatisfiedLinkError(e.getMessage());
        }
        try {
            OpList opList = TensorFlow.libraryOpList(h);
            return opList;
        }
        finally {
            TensorFlow.libraryDelete(h);
        }
    }

    private static TF_Library libraryLoad(String filename) {
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            TF_Library h = tensorflow.TF_LoadLibrary(filename, status);
            status.throwExceptionIfNotOK();
            TF_Library tF_Library = h;
            return tF_Library;
        }
    }

    private static void libraryDelete(TF_Library handle) {
        if (handle != null && !handle.isNull()) {
            tensorflow.TF_DeleteLibraryHandle(handle);
        }
    }

    private static OpList libraryOpList(TF_Library handle) {
        TF_Buffer buf = tensorflow.TF_GetOpList(handle);
        try {
            return OpList.parseFrom(buf.dataAsByteBuffer());
        }
        catch (InvalidProtocolBufferException e) {
            throw new TensorFlowException("Cannot parse OpList protocol buffer", e);
        }
    }

    private TensorFlow() {
    }

    static void init() {
        try {
            NativeLibrary.load();
        }
        catch (Exception e) {
            System.err.println("Failed to load TensorFlow native library");
            e.printStackTrace();
            throw e;
        }
    }

    static {
        TensorFlow.init();
    }
}

