/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class OutfeedDequeueTuple
extends RawOp
implements Iterable<Operand<TType>> {
    private List<Output<?>> outputs;

    public static OutfeedDequeueTuple create(Scope scope, List<DataType<?>> dtypes, List<Shape> shapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("OutfeedDequeueTuple", scope.makeOpName("OutfeedDequeueTuple"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] dtypesArray = new DataType[dtypes.size()];
        for (int i = 0; i < dtypesArray.length; ++i) {
            dtypesArray[i] = dtypes.get(i);
        }
        opBuilder.setAttr("dtypes", dtypesArray);
        Shape[] shapesArray = new Shape[shapes.size()];
        for (int i = 0; i < shapesArray.length; ++i) {
            shapesArray[i] = shapes.get(i);
        }
        opBuilder.setAttr("shapes", shapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.deviceOrdinal == null) continue;
                opBuilder.setAttr("device_ordinal", opts.deviceOrdinal);
            }
        }
        return new OutfeedDequeueTuple(opBuilder.build());
    }

    public static Options deviceOrdinal(Long deviceOrdinal) {
        return new Options().deviceOrdinal(deviceOrdinal);
    }

    public List<Output<?>> outputs() {
        return this.outputs;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.outputs.iterator();
    }

    private OutfeedDequeueTuple(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputsLength = operation.outputListLength("outputs");
        this.outputs = Arrays.asList(operation.outputList(outputIdx, outputsLength));
        outputIdx += outputsLength;
    }

    public static class Options {
        private Long deviceOrdinal;

        public Options deviceOrdinal(Long deviceOrdinal) {
            this.deviceOrdinal = deviceOrdinal;
            return this;
        }

        private Options() {
        }
    }
}

