/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;

public final class SparseBincount<U extends TNumber>
extends RawOp
implements Operand<U> {
    private Output<U> output;

    public static <U extends TNumber, T extends TNumber> SparseBincount<U> create(Scope scope, Operand<TInt64> indices, Operand<T> values, Operand<TInt64> denseShape, Operand<T> size, Operand<U> weights, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("SparseBincount", scope.makeOpName("SparseBincount"));
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(values.asOutput());
        opBuilder.addInput(denseShape.asOutput());
        opBuilder.addInput(size.asOutput());
        opBuilder.addInput(weights.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.binaryOutput == null) continue;
                opBuilder.setAttr("binary_output", opts.binaryOutput);
            }
        }
        return new SparseBincount<U>(opBuilder.build());
    }

    public static Options binaryOutput(Boolean binaryOutput) {
        return new Options().binaryOutput(binaryOutput);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    private SparseBincount(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean binaryOutput;

        public Options binaryOutput(Boolean binaryOutput) {
            this.binaryOutput = binaryOutput;
            return this;
        }

        private Options() {
        }
    }
}

