/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TNumber;

public final class DepthwiseConv2dNative<T extends TNumber>
extends RawOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends TNumber> DepthwiseConv2dNative<T> create(Scope scope, Operand<T> input, Operand<T> filter, List<Long> strides, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("DepthwiseConv2dNative", scope.makeOpName("DepthwiseConv2dNative"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(filter.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                int i;
                if (opts.explicitPaddings != null) {
                    long[] explicitPaddingsArray = new long[opts.explicitPaddings.size()];
                    for (i = 0; i < explicitPaddingsArray.length; ++i) {
                        explicitPaddingsArray[i] = (Long)opts.explicitPaddings.get(i);
                    }
                    opBuilder.setAttr("explicit_paddings", explicitPaddingsArray);
                }
                if (opts.dataFormat != null) {
                    opBuilder.setAttr("data_format", opts.dataFormat);
                }
                if (opts.dilations == null) continue;
                long[] dilationsArray = new long[opts.dilations.size()];
                for (i = 0; i < dilationsArray.length; ++i) {
                    dilationsArray[i] = (Long)opts.dilations.get(i);
                }
                opBuilder.setAttr("dilations", dilationsArray);
            }
        }
        return new DepthwiseConv2dNative<T>(opBuilder.build());
    }

    public static Options explicitPaddings(List<Long> explicitPaddings) {
        return new Options().explicitPaddings(explicitPaddings);
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public static Options dilations(List<Long> dilations) {
        return new Options().dilations(dilations);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private DepthwiseConv2dNative(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private List<Long> explicitPaddings;
        private String dataFormat;
        private List<Long> dilations;

        public Options explicitPaddings(List<Long> explicitPaddings) {
            this.explicitPaddings = explicitPaddings;
            return this;
        }

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Options dilations(List<Long> dilations) {
            this.dilations = dilations;
            return this;
        }

        private Options() {
        }
    }
}

