/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data.experimental;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class UncompressElement
extends RawOp
implements Iterable<Operand<TType>> {
    private List<Output<?>> components;

    public static UncompressElement create(Scope scope, Operand<?> compressed, List<DataType<?>> outputTypes, List<Shape> outputShapes) {
        OperationBuilder opBuilder = scope.env().opBuilder("UncompressElement", scope.makeOpName("UncompressElement"));
        opBuilder.addInput(compressed.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] outputTypesArray = new DataType[outputTypes.size()];
        for (int i = 0; i < outputTypesArray.length; ++i) {
            outputTypesArray[i] = outputTypes.get(i);
        }
        opBuilder.setAttr("output_types", outputTypesArray);
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        return new UncompressElement(opBuilder.build());
    }

    public List<Output<?>> components() {
        return this.components;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.components.iterator();
    }

    private UncompressElement(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int componentsLength = operation.outputListLength("components");
        this.components = Arrays.asList(operation.outputList(outputIdx, componentsLength));
        outputIdx += componentsLength;
    }
}

