/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class Variable<T extends TType>
extends RawOp
implements Operand<T> {
    private Output<T> ref;

    public static <T extends TType> Variable<T> create(Scope scope, Shape shape, DataType<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("VariableV2", scope.makeOpName("Variable"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("shape", shape);
        opBuilder.setAttr("dtype", dtype);
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new Variable<T>(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<T> ref() {
        return this.ref;
    }

    @Override
    public Output<T> asOutput() {
        return this.ref;
    }

    private Variable(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.ref = operation.output(outputIdx++);
    }

    public static class Options {
        private String container;
        private String sharedName;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        private Options() {
        }
    }
}

