/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class MutableDenseHashTable
extends RawOp
implements Operand<TType> {
    private Output<?> tableHandle;

    public static <T extends TType, U extends TType> MutableDenseHashTable create(Scope scope, Operand<T> emptyKey, Operand<T> deletedKey, DataType<U> valueDtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("MutableDenseHashTableV2", scope.makeOpName("MutableDenseHashTable"));
        opBuilder.addInput(emptyKey.asOutput());
        opBuilder.addInput(deletedKey.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("value_dtype", valueDtype);
        if (options != null) {
            for (Options opts : options) {
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName != null) {
                    opBuilder.setAttr("shared_name", opts.sharedName);
                }
                if (opts.useNodeNameSharing != null) {
                    opBuilder.setAttr("use_node_name_sharing", opts.useNodeNameSharing);
                }
                if (opts.valueShape != null) {
                    opBuilder.setAttr("value_shape", opts.valueShape);
                }
                if (opts.initialNumBuckets != null) {
                    opBuilder.setAttr("initial_num_buckets", opts.initialNumBuckets);
                }
                if (opts.maxLoadFactor == null) continue;
                opBuilder.setAttr("max_load_factor", opts.maxLoadFactor.floatValue());
            }
        }
        return new MutableDenseHashTable(opBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options useNodeNameSharing(Boolean useNodeNameSharing) {
        return new Options().useNodeNameSharing(useNodeNameSharing);
    }

    public static Options valueShape(Shape valueShape) {
        return new Options().valueShape(valueShape);
    }

    public static Options initialNumBuckets(Long initialNumBuckets) {
        return new Options().initialNumBuckets(initialNumBuckets);
    }

    public static Options maxLoadFactor(Float maxLoadFactor) {
        return new Options().maxLoadFactor(maxLoadFactor);
    }

    public Output<?> tableHandle() {
        return this.tableHandle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.tableHandle;
    }

    private MutableDenseHashTable(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.tableHandle = operation.output(outputIdx++);
    }

    public static class Options {
        private String container;
        private String sharedName;
        private Boolean useNodeNameSharing;
        private Shape valueShape;
        private Long initialNumBuckets;
        private Float maxLoadFactor;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options useNodeNameSharing(Boolean useNodeNameSharing) {
            this.useNodeNameSharing = useNodeNameSharing;
            return this;
        }

        public Options valueShape(Shape valueShape) {
            this.valueShape = valueShape;
            return this;
        }

        public Options initialNumBuckets(Long initialNumBuckets) {
            this.initialNumBuckets = initialNumBuckets;
            return this;
        }

        public Options maxLoadFactor(Float maxLoadFactor) {
            this.maxLoadFactor = maxLoadFactor;
            return this;
        }

        private Options() {
        }
    }
}

