/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;

public final class CtcGreedyDecoder<T extends TNumber>
extends RawOp {
    private Output<TInt64> decodedIndices;
    private Output<TInt64> decodedValues;
    private Output<TInt64> decodedShape;
    private Output<T> logProbability;

    public static <T extends TNumber> CtcGreedyDecoder<T> create(Scope scope, Operand<T> inputs, Operand<TInt32> sequenceLength, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("CTCGreedyDecoder", scope.makeOpName("CtcGreedyDecoder"));
        opBuilder.addInput(inputs.asOutput());
        opBuilder.addInput(sequenceLength.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.mergeRepeated == null) continue;
                opBuilder.setAttr("merge_repeated", opts.mergeRepeated);
            }
        }
        return new CtcGreedyDecoder<T>(opBuilder.build());
    }

    public static Options mergeRepeated(Boolean mergeRepeated) {
        return new Options().mergeRepeated(mergeRepeated);
    }

    public Output<TInt64> decodedIndices() {
        return this.decodedIndices;
    }

    public Output<TInt64> decodedValues() {
        return this.decodedValues;
    }

    public Output<TInt64> decodedShape() {
        return this.decodedShape;
    }

    public Output<T> logProbability() {
        return this.logProbability;
    }

    private CtcGreedyDecoder(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.decodedIndices = operation.output(outputIdx++);
        this.decodedValues = operation.output(outputIdx++);
        this.decodedShape = operation.output(outputIdx++);
        this.logProbability = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean mergeRepeated;

        public Options mergeRepeated(Boolean mergeRepeated) {
            this.mergeRepeated = mergeRepeated;
            return this;
        }

        private Options() {
        }
    }
}

