/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.ndarray.impl.dense;

import org.tensorflow.tools.Shape;
import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.ndarray.IllegalRankException;
import org.tensorflow.tools.ndarray.impl.dimension.DimensionalSpace;

final class Validator
extends org.tensorflow.tools.ndarray.impl.Validator {
    static void coordinates(DimensionalSpace dimensions, long[] coords, boolean isValue) {
        if (coords.length > dimensions.numDimensions()) {
            throw new IndexOutOfBoundsException();
        }
        if (isValue && coords.length != dimensions.numDimensions()) {
            throw new IllegalRankException("Not a scalar value");
        }
    }

    static void denseShape(DataBuffer<?> buffer, Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Shape cannot be null");
        }
        if (shape.hasUnknownDimension()) {
            throw new IllegalArgumentException("Dense arrays cannot have unknown dimension(s)");
        }
        if (buffer.size() < shape.size()) {
            throw new IllegalArgumentException("Buffer size is smaller than the shape size");
        }
    }

    private Validator() {
    }
}

