/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.buffer.impl.layout;

import java.nio.charset.Charset;
import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.layout.DataLayout;

public final class StringLayout
implements DataLayout<DataBuffer<byte[]>, String> {
    private final Charset charset;

    public static StringLayout of(Charset charset) {
        return new StringLayout(charset);
    }

    @Override
    public void writeObject(DataBuffer<byte[]> buffer, String value, long index) {
        buffer.setObject(value.getBytes(this.charset), index);
    }

    @Override
    public String readObject(DataBuffer<byte[]> buffer, long index) {
        return new String(buffer.getObject(index), this.charset);
    }

    private StringLayout(Charset charset) {
        this.charset = charset;
    }
}

