/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TString;

public final class BoostedTreesSparseCalculateBestFeatureSplit
extends RawOp {
    private Output<TInt32> nodeIds;
    private Output<TFloat32> gains;
    private Output<TInt32> featureDimensions;
    private Output<TInt32> thresholds;
    private Output<TFloat32> leftNodeContribs;
    private Output<TFloat32> rightNodeContribs;
    private Output<TString> splitWithDefaultDirections;

    public static BoostedTreesSparseCalculateBestFeatureSplit create(Scope scope, Operand<TInt32> nodeIdRange, Operand<TInt32> statsSummaryIndices, Operand<TFloat32> statsSummaryValues, Operand<TInt32> statsSummaryShape, Operand<TFloat32> l1, Operand<TFloat32> l2, Operand<TFloat32> treeComplexity, Operand<TFloat32> minNodeWeight, Long logitsDimension, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("BoostedTreesSparseCalculateBestFeatureSplit", scope.makeOpName("BoostedTreesSparseCalculateBestFeatureSplit"));
        opBuilder.addInput(nodeIdRange.asOutput());
        opBuilder.addInput(statsSummaryIndices.asOutput());
        opBuilder.addInput(statsSummaryValues.asOutput());
        opBuilder.addInput(statsSummaryShape.asOutput());
        opBuilder.addInput(l1.asOutput());
        opBuilder.addInput(l2.asOutput());
        opBuilder.addInput(treeComplexity.asOutput());
        opBuilder.addInput(minNodeWeight.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("logits_dimension", logitsDimension);
        if (options != null) {
            for (Options opts : options) {
                if (opts.splitType == null) continue;
                opBuilder.setAttr("split_type", opts.splitType);
            }
        }
        return new BoostedTreesSparseCalculateBestFeatureSplit(opBuilder.build());
    }

    public static Options splitType(String splitType) {
        return new Options().splitType(splitType);
    }

    public Output<TInt32> nodeIds() {
        return this.nodeIds;
    }

    public Output<TFloat32> gains() {
        return this.gains;
    }

    public Output<TInt32> featureDimensions() {
        return this.featureDimensions;
    }

    public Output<TInt32> thresholds() {
        return this.thresholds;
    }

    public Output<TFloat32> leftNodeContribs() {
        return this.leftNodeContribs;
    }

    public Output<TFloat32> rightNodeContribs() {
        return this.rightNodeContribs;
    }

    public Output<TString> splitWithDefaultDirections() {
        return this.splitWithDefaultDirections;
    }

    private BoostedTreesSparseCalculateBestFeatureSplit(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.nodeIds = operation.output(outputIdx++);
        this.gains = operation.output(outputIdx++);
        this.featureDimensions = operation.output(outputIdx++);
        this.thresholds = operation.output(outputIdx++);
        this.leftNodeContribs = operation.output(outputIdx++);
        this.rightNodeContribs = operation.output(outputIdx++);
        this.splitWithDefaultDirections = operation.output(outputIdx++);
    }

    public static class Options {
        private String splitType;

        public Options splitType(String splitType) {
            this.splitType = splitType;
            return this;
        }

        private Options() {
        }
    }
}

