/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class StridedSliceGrad<U extends TType>
extends RawOp
implements Operand<U> {
    private Output<U> output;

    public static <U extends TType, T extends TNumber> StridedSliceGrad<U> create(Scope scope, Operand<T> shape, Operand<T> begin, Operand<T> end, Operand<T> strides, Operand<U> dy, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("StridedSliceGrad", scope.makeOpName("StridedSliceGrad"));
        opBuilder.addInput(shape.asOutput());
        opBuilder.addInput(begin.asOutput());
        opBuilder.addInput(end.asOutput());
        opBuilder.addInput(strides.asOutput());
        opBuilder.addInput(dy.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.beginMask != null) {
                    opBuilder.setAttr("begin_mask", opts.beginMask);
                }
                if (opts.endMask != null) {
                    opBuilder.setAttr("end_mask", opts.endMask);
                }
                if (opts.ellipsisMask != null) {
                    opBuilder.setAttr("ellipsis_mask", opts.ellipsisMask);
                }
                if (opts.newAxisMask != null) {
                    opBuilder.setAttr("new_axis_mask", opts.newAxisMask);
                }
                if (opts.shrinkAxisMask == null) continue;
                opBuilder.setAttr("shrink_axis_mask", opts.shrinkAxisMask);
            }
        }
        return new StridedSliceGrad<U>(opBuilder.build());
    }

    public static Options beginMask(Long beginMask) {
        return new Options().beginMask(beginMask);
    }

    public static Options endMask(Long endMask) {
        return new Options().endMask(endMask);
    }

    public static Options ellipsisMask(Long ellipsisMask) {
        return new Options().ellipsisMask(ellipsisMask);
    }

    public static Options newAxisMask(Long newAxisMask) {
        return new Options().newAxisMask(newAxisMask);
    }

    public static Options shrinkAxisMask(Long shrinkAxisMask) {
        return new Options().shrinkAxisMask(shrinkAxisMask);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    private StridedSliceGrad(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Long beginMask;
        private Long endMask;
        private Long ellipsisMask;
        private Long newAxisMask;
        private Long shrinkAxisMask;

        public Options beginMask(Long beginMask) {
            this.beginMask = beginMask;
            return this;
        }

        public Options endMask(Long endMask) {
            this.endMask = endMask;
            return this;
        }

        public Options ellipsisMask(Long ellipsisMask) {
            this.ellipsisMask = ellipsisMask;
            return this;
        }

        public Options newAxisMask(Long newAxisMask) {
            this.newAxisMask = newAxisMask;
            return this;
        }

        public Options shrinkAxisMask(Long shrinkAxisMask) {
            this.shrinkAxisMask = shrinkAxisMask;
            return this;
        }

        private Options() {
        }
    }
}

