/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.ndarray.impl.dense;

import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.ndarray.IllegalRankException;
import org.tensorflow.tools.ndarray.NdArray;
import org.tensorflow.tools.ndarray.impl.AbstractNdArray;
import org.tensorflow.tools.ndarray.impl.dense.DataTransfer;
import org.tensorflow.tools.ndarray.impl.dense.Validator;
import org.tensorflow.tools.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.tools.ndarray.impl.dimension.RelativeDimensionalSpace;
import org.tensorflow.tools.ndarray.index.Index;

public abstract class AbstractDenseNdArray<T, U extends NdArray<T>>
extends AbstractNdArray<T, U> {
    @Override
    public U slice(long position, DimensionalSpace sliceDimensions) {
        DataBuffer<T> sliceBuffer = this.buffer().slice(position, sliceDimensions.physicalSize());
        return this.instantiate(sliceBuffer, sliceDimensions);
    }

    public U slice(Index ... indices) {
        if (indices == null) {
            throw new IllegalArgumentException("Slicing requires at least one index");
        }
        RelativeDimensionalSpace sliceDimensions = this.dimensions().mapTo(indices);
        return this.slice(sliceDimensions.position(), sliceDimensions);
    }

    public U get(long ... coords) {
        return this.slice(this.positionOf(coords, false), this.dimensions().from(coords.length));
    }

    @Override
    public T getObject(long ... coords) {
        return this.buffer().getObject(this.positionOf(coords, true));
    }

    public U set(NdArray<T> src, long ... coordinates) {
        src.copyTo(coordinates == null || coordinates.length == 0 ? this : this.get(coordinates));
        return (U)this;
    }

    public U setObject(T value, long ... coords) {
        this.buffer().setObject(value, this.positionOf(coords, true));
        return (U)this;
    }

    public U read(DataBuffer<T> dst) {
        Validator.readToBufferArgs(this, dst);
        DataTransfer.execute(this.buffer(), this.dimensions(), dst, DataTransfer::ofValue);
        return (U)this;
    }

    public U write(DataBuffer<T> src) {
        Validator.writeFromBufferArgs(this, src);
        DataTransfer.execute(src, this.buffer(), this.dimensions(), DataTransfer::ofValue);
        return (U)this;
    }

    @Override
    public int hashCode() {
        if (this.dimensions().isSegmented()) {
            return this.slowHashCode();
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + this.buffer().hashCode();
        result = 31 * result + this.shape().hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractDenseNdArray)) {
            return super.equals(obj);
        }
        AbstractDenseNdArray other = (AbstractDenseNdArray)obj;
        if (this.dimensions().isSegmented() || other.dimensions().isSegmented()) {
            return this.slowEquals(other);
        }
        if (!this.shape().equals(other.shape())) {
            return false;
        }
        return this.buffer().equals(other.buffer());
    }

    protected AbstractDenseNdArray(DimensionalSpace dimensions) {
        super(dimensions);
    }

    protected abstract DataBuffer<T> buffer();

    abstract U instantiate(DataBuffer<T> var1, DimensionalSpace var2);

    long positionOf(long[] coords, boolean isValue) {
        if (coords == null || coords.length == 0) {
            return 0L;
        }
        if (coords.length > this.dimensions().numDimensions()) {
            throw new IndexOutOfBoundsException();
        }
        if (isValue && coords.length != this.dimensions().numDimensions()) {
            throw new IllegalRankException("Not a scalar value");
        }
        return this.dimensions().positionOf(coords);
    }

    @Override
    protected void slowCopyTo(NdArray<T> array) {
        if (array instanceof AbstractDenseNdArray) {
            AbstractDenseNdArray dst = (AbstractDenseNdArray)array;
            long offset = 0L;
            for (NdArray s : this.scalars()) {
                dst.buffer().setObject(s.getObject(new long[0]), offset++);
            }
        } else {
            super.slowCopyTo(array);
        }
    }
}

