/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.buffer.impl.raw;

import java.nio.LongBuffer;
import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.DataStorageVisitor;
import org.tensorflow.tools.buffer.LongDataBuffer;
import org.tensorflow.tools.buffer.impl.Validator;
import org.tensorflow.tools.buffer.impl.raw.AbstractRawDataBuffer;
import org.tensorflow.tools.buffer.impl.raw.UnsafeMemoryHandle;

final class LongRawDataBuffer
extends AbstractRawDataBuffer<Long, LongDataBuffer>
implements LongDataBuffer {
    @Override
    public long getLong(long index) {
        Validator.getArgs(this, index);
        return this.memory.getLong(index);
    }

    @Override
    public LongDataBuffer setLong(long value, long index) {
        Validator.setArgs(this, index);
        this.memory.setLong(value, index);
        return this;
    }

    @Override
    public LongDataBuffer read(long[] dst) {
        return (LongDataBuffer)this.read(dst, dst.length);
    }

    @Override
    public LongDataBuffer read(long[] dst, int offset, int length) {
        return (LongDataBuffer)this.read(dst, dst.length, offset, length);
    }

    @Override
    public LongDataBuffer write(long[] src) {
        return (LongDataBuffer)this.write(src, src.length);
    }

    @Override
    public LongDataBuffer write(long[] src, int offset, int length) {
        return (LongDataBuffer)this.write(src, src.length, offset, length);
    }

    @Override
    public LongDataBuffer copyTo(final DataBuffer<Long> dst, final long size) {
        Validator.copyToArgs(this, dst, size);
        return dst.accept(new DataStorageVisitor<LongDataBuffer>(){

            @Override
            public LongDataBuffer visit(LongBuffer buffer) {
                if (buffer.hasArray()) {
                    LongRawDataBuffer.this.memory.copyTo(UnsafeMemoryHandle.fromArray(buffer.array(), buffer.position(), buffer.capacity()), size);
                } else if (LongRawDataBuffer.this.memory.isArray()) {
                    buffer.put(LongRawDataBuffer.this.memory.toArrayLongBuffer());
                } else {
                    LongRawDataBuffer.this.slowCopyTo(dst, size);
                }
                return LongRawDataBuffer.this;
            }

            @Override
            public LongDataBuffer visit(long address, long length, long scale) {
                LongRawDataBuffer.this.memory.copyTo(UnsafeMemoryHandle.fromAddress(address, length, scale), size);
                return LongRawDataBuffer.this;
            }

            @Override
            public LongDataBuffer fallback() {
                if (dst instanceof LongDataBuffer) {
                    LongDataBuffer longDst = (LongDataBuffer)dst;
                    for (long idx = 0L; idx < size; ++idx) {
                        longDst.setLong(LongRawDataBuffer.this.getLong(idx), idx);
                    }
                    return LongRawDataBuffer.this;
                }
                return (LongDataBuffer)LongRawDataBuffer.this.slowCopyTo(dst, size);
            }
        });
    }

    @Override
    public <R> R accept(DataStorageVisitor<R> visitor) {
        if (this.memory.isArray()) {
            return visitor.visit(this.memory.toArrayLongBuffer());
        }
        return visitor.visit(this.memory.byteOffset, this.memory.byteSize, this.memory.scale);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongDataBuffer)) {
            return super.equals(obj);
        }
        final LongDataBuffer other = (LongDataBuffer)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return other.accept(new DataStorageVisitor<Boolean>(){

            @Override
            public Boolean visit(LongBuffer buffer) {
                if (LongRawDataBuffer.this.memory.isArray()) {
                    return buffer.equals(LongRawDataBuffer.this.memory.toArrayLongBuffer());
                }
                return this.fallback();
            }

            @Override
            public Boolean fallback() {
                for (long idx = 0L; idx < LongRawDataBuffer.this.size(); ++idx) {
                    if (other.getLong(idx) == LongRawDataBuffer.this.getLong(idx)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    protected LongDataBuffer instantiate(UnsafeMemoryHandle memory) {
        return new LongRawDataBuffer(memory, this.readOnly);
    }

    LongRawDataBuffer(UnsafeMemoryHandle memory, boolean readOnly) {
        super(memory, readOnly);
    }
}

