/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.buffer.impl.adapter;

import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.ShortDataBuffer;
import org.tensorflow.tools.buffer.impl.Validator;
import org.tensorflow.tools.buffer.impl.adapter.AbstractDataBufferAdapter;
import org.tensorflow.tools.buffer.layout.ShortDataLayout;

class ShortDataBufferAdapter<S extends DataBuffer<?>>
extends AbstractDataBufferAdapter<S, Short, ShortDataBuffer>
implements ShortDataBuffer {
    private ShortDataLayout<S> layout;

    @Override
    public short getShort(long index) {
        Validator.getArgs(this, index);
        return this.layout.readShort(this.buffer(), index * (long)this.layout.scale());
    }

    @Override
    public ShortDataBuffer setShort(short value, long index) {
        Validator.setArgs(this, index);
        this.layout.writeShort(this.buffer(), value, index * (long)this.layout.scale());
        return this;
    }

    @Override
    public ShortDataBuffer read(short[] dst, int offset, int length) {
        Validator.readArgs(this, dst.length, offset, length);
        int i = 0;
        int j = offset;
        while (i < length) {
            dst[j] = this.layout.readShort(this.buffer(), i * this.layout.scale());
            ++i;
            ++j;
        }
        return this;
    }

    @Override
    public ShortDataBuffer write(short[] src, int offset, int length) {
        Validator.writeArgs(this, src.length, offset, length);
        int i = 0;
        int j = offset;
        while (i < length) {
            this.layout.writeShort(this.buffer(), src[j], i * this.layout.scale());
            ++i;
            ++j;
        }
        return this;
    }

    @Override
    public ShortDataBuffer copyTo(DataBuffer<Short> dst, long size) {
        Validator.copyToArgs(this, dst, size);
        if (dst instanceof ShortDataBuffer) {
            ShortDataBuffer shortDst = (ShortDataBuffer)dst;
            for (long idx = 0L; idx < size; ++idx) {
                shortDst.setShort(this.getShort(idx), idx);
            }
            return this;
        }
        return (ShortDataBuffer)this.slowCopyTo(dst, size);
    }

    @Override
    public ShortDataBuffer offset(long index) {
        return new ShortDataBufferAdapter(this.buffer().offset(index * (long)this.layout.scale()), this.layout);
    }

    @Override
    public ShortDataBuffer narrow(long size) {
        return new ShortDataBufferAdapter(this.buffer().narrow(size * (long)this.layout.scale()), this.layout);
    }

    @Override
    public ShortDataBuffer slice(long index, long size) {
        return new ShortDataBufferAdapter(this.buffer().slice(index * (long)this.layout.scale(), size * (long)this.layout.scale()), this.layout);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShortDataBuffer)) {
            return super.equals(obj);
        }
        ShortDataBuffer other = (ShortDataBuffer)obj;
        if (other.size() != this.size()) {
            return false;
        }
        for (long idx = 0L; idx < this.size(); ++idx) {
            if (other.getShort(idx) == this.getShort(idx)) continue;
            return false;
        }
        return true;
    }

    ShortDataBufferAdapter(S buffer, ShortDataLayout<S> layout) {
        super(buffer, layout);
        this.layout = layout;
    }
}

