/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.buffer.impl.adapter;

import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.DoubleDataBuffer;
import org.tensorflow.tools.buffer.impl.Validator;
import org.tensorflow.tools.buffer.impl.adapter.AbstractDataBufferAdapter;
import org.tensorflow.tools.buffer.layout.DoubleDataLayout;

class DoubleDataBufferAdapter<S extends DataBuffer<?>>
extends AbstractDataBufferAdapter<S, Double, DoubleDataBuffer>
implements DoubleDataBuffer {
    private DoubleDataLayout<S> layout;

    @Override
    public double getDouble(long index) {
        Validator.getArgs(this, index);
        return this.layout.readDouble(this.buffer(), index * (long)this.layout.scale());
    }

    @Override
    public DoubleDataBuffer setDouble(double value, long index) {
        Validator.setArgs(this, index);
        this.layout.writeDouble(this.buffer(), value, index * (long)this.layout.scale());
        return this;
    }

    @Override
    public DoubleDataBuffer read(double[] dst, int offset, int length) {
        Validator.readArgs(this, dst.length, offset, length);
        int i = 0;
        int j = offset;
        while (i < length) {
            dst[j] = this.layout.readDouble(this.buffer(), i * this.layout.scale());
            ++i;
            ++j;
        }
        return this;
    }

    @Override
    public DoubleDataBuffer write(double[] src, int offset, int length) {
        Validator.writeArgs(this, src.length, offset, length);
        int i = 0;
        int j = offset;
        while (i < length) {
            this.layout.writeDouble(this.buffer(), src[j], i * this.layout.scale());
            ++i;
            ++j;
        }
        return this;
    }

    @Override
    public DoubleDataBuffer copyTo(DataBuffer<Double> dst, long size) {
        Validator.copyToArgs(this, dst, size);
        if (dst instanceof DoubleDataBuffer) {
            DoubleDataBuffer doubleDst = (DoubleDataBuffer)dst;
            for (long idx = 0L; idx < size; ++idx) {
                doubleDst.setDouble(this.getDouble(idx), idx);
            }
            return this;
        }
        return (DoubleDataBuffer)this.slowCopyTo(dst, size);
    }

    @Override
    public DoubleDataBuffer offset(long index) {
        return new DoubleDataBufferAdapter(this.buffer().offset(index * (long)this.layout.scale()), this.layout);
    }

    @Override
    public DoubleDataBuffer narrow(long size) {
        return new DoubleDataBufferAdapter(this.buffer().narrow(size * (long)this.layout.scale()), this.layout);
    }

    @Override
    public DoubleDataBuffer slice(long index, long size) {
        return new DoubleDataBufferAdapter(this.buffer().slice(index * (long)this.layout.scale(), size * (long)this.layout.scale()), this.layout);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleDataBuffer)) {
            return super.equals(obj);
        }
        DoubleDataBuffer other = (DoubleDataBuffer)obj;
        if (other.size() != this.size()) {
            return false;
        }
        for (long idx = 0L; idx < this.size(); ++idx) {
            if (other.getDouble(idx) == this.getDouble(idx)) continue;
            return false;
        }
        return true;
    }

    DoubleDataBufferAdapter(S buffer, DoubleDataLayout<S> layout) {
        super(buffer, layout);
        this.layout = layout;
    }
}

