/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools;

import java.util.Arrays;

public final class Shape {
    public static long UNKNOWN_SIZE = -1L;
    private final long[] dimensionSizes;
    private Long size;

    public static Shape unknown() {
        return new Shape(null);
    }

    public static Shape scalar() {
        return new Shape(new long[0]);
    }

    public static Shape of(long ... dimensionSizes) {
        if (dimensionSizes == null || dimensionSizes.length == 0) {
            return Shape.scalar();
        }
        return new Shape(dimensionSizes);
    }

    public long size() {
        if (this.size == null) {
            this.size = Shape.computeSize(this.dimensionSizes);
        }
        return this.size;
    }

    public long size(int i) {
        return this.dimensionSizes != null ? this.dimensionSizes[i] : UNKNOWN_SIZE;
    }

    public int numDimensions() {
        return this.dimensionSizes != null ? this.dimensionSizes.length : -1;
    }

    public boolean hasUnknownDimension() {
        if (this.dimensionSizes == null) {
            return true;
        }
        for (long dimSize : this.dimensionSizes) {
            if (dimSize != UNKNOWN_SIZE) continue;
            return true;
        }
        return false;
    }

    public long[] asArray() {
        return this.dimensionSizes;
    }

    public int hashCode() {
        return this.dimensionSizes != null ? Arrays.hashCode(this.dimensionSizes) : super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Shape) {
            Shape otherShape = (Shape)obj;
            if (otherShape.hasUnknownDimension()) {
                return false;
            }
            return Arrays.equals(this.dimensionSizes, otherShape.dimensionSizes);
        }
        return false;
    }

    public String toString() {
        return Arrays.toString(this.dimensionSizes);
    }

    private Shape(long[] dimensionSizes) {
        this.dimensionSizes = dimensionSizes;
    }

    public Shape head() {
        return Shape.of(this.size(0));
    }

    public Shape tail() {
        if (this.dimensionSizes.length < 2) {
            return Shape.of(new long[0]);
        }
        return Shape.of(Arrays.copyOfRange(this.dimensionSizes, 1, this.dimensionSizes.length));
    }

    public Shape prepend(long firstDimension) {
        long[] newDimensions = new long[this.dimensionSizes.length + 1];
        newDimensions[0] = firstDimension;
        System.arraycopy(this.dimensionSizes, 0, newDimensions, 1, this.dimensionSizes.length);
        return Shape.of(newDimensions);
    }

    private static long computeSize(long[] dimensionSizes) {
        if (dimensionSizes == null) {
            return UNKNOWN_SIZE;
        }
        long computedSize = 1L;
        for (long dimensionSize : dimensionSizes) {
            if (dimensionSize == UNKNOWN_SIZE) {
                return UNKNOWN_SIZE;
            }
            computedSize *= dimensionSize;
        }
        return computedSize;
    }
}

