/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.strings;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;

public final class StringSplit
extends RawOp {
    private Output<TInt64> indices;
    private Output<TString> values;
    private Output<TInt64> shape;

    public static StringSplit create(Scope scope, Operand<TString> input, Operand<TString> sep, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("StringSplitV2", scope.makeOpName("StringSplit"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(sep.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.maxsplit == null) continue;
                opBuilder.setAttr("maxsplit", opts.maxsplit);
            }
        }
        return new StringSplit(opBuilder.build());
    }

    public static Options maxsplit(Long maxsplit) {
        return new Options().maxsplit(maxsplit);
    }

    public Output<TInt64> indices() {
        return this.indices;
    }

    public Output<TString> values() {
        return this.values;
    }

    public Output<TInt64> shape() {
        return this.shape;
    }

    private StringSplit(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.indices = operation.output(outputIdx++);
        this.values = operation.output(outputIdx++);
        this.shape = operation.output(outputIdx++);
    }

    public static class Options {
        private Long maxsplit;

        public Options maxsplit(Long maxsplit) {
            this.maxsplit = maxsplit;
            return this;
        }

        private Options() {
        }
    }
}

