/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class QueueDequeue
extends RawOp
implements Iterable<Operand<TType>> {
    private List<Output<?>> components;

    public static QueueDequeue create(Scope scope, Operand<?> handle, List<DataType<?>> componentTypes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("QueueDequeueV2", scope.makeOpName("QueueDequeue"));
        opBuilder.addInput(handle.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] componentTypesArray = new DataType[componentTypes.size()];
        for (int i = 0; i < componentTypesArray.length; ++i) {
            componentTypesArray[i] = componentTypes.get(i);
        }
        opBuilder.setAttr("component_types", componentTypesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.timeoutMs == null) continue;
                opBuilder.setAttr("timeout_ms", opts.timeoutMs);
            }
        }
        return new QueueDequeue(opBuilder.build());
    }

    public static Options timeoutMs(Long timeoutMs) {
        return new Options().timeoutMs(timeoutMs);
    }

    public List<Output<?>> components() {
        return this.components;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.components.iterator();
    }

    private QueueDequeue(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int componentsLength = operation.outputListLength("components");
        this.components = Arrays.asList(operation.outputList(outputIdx, componentsLength));
        outputIdx += componentsLength;
    }

    public static class Options {
        private Long timeoutMs;

        public Options timeoutMs(Long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }

        private Options() {
        }
    }
}

