/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

public final class ScaleAndTranslateGrad<T extends TNumber>
extends RawOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends TNumber> ScaleAndTranslateGrad<T> create(Scope scope, Operand<T> grads, Operand<T> originalImage, Operand<TFloat32> scale, Operand<TFloat32> translation, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("ScaleAndTranslateGrad", scope.makeOpName("ScaleAndTranslateGrad"));
        opBuilder.addInput(grads.asOutput());
        opBuilder.addInput(originalImage.asOutput());
        opBuilder.addInput(scale.asOutput());
        opBuilder.addInput(translation.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.kernelType != null) {
                    opBuilder.setAttr("kernel_type", opts.kernelType);
                }
                if (opts.antialias == null) continue;
                opBuilder.setAttr("antialias", opts.antialias);
            }
        }
        return new ScaleAndTranslateGrad<T>(opBuilder.build());
    }

    public static Options kernelType(String kernelType) {
        return new Options().kernelType(kernelType);
    }

    public static Options antialias(Boolean antialias) {
        return new Options().antialias(antialias);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private ScaleAndTranslateGrad(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private String kernelType;
        private Boolean antialias;

        public Options kernelType(String kernelType) {
            this.kernelType = kernelType;
            return this;
        }

        public Options antialias(Boolean antialias) {
            this.antialias = antialias;
            return this;
        }

        private Options() {
        }
    }
}

