/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.nio.charset.Charset;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.Output;
import org.tensorflow.Tensor;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.tools.Shape;
import org.tensorflow.tools.buffer.BooleanDataBuffer;
import org.tensorflow.tools.buffer.ByteDataBuffer;
import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.DoubleDataBuffer;
import org.tensorflow.tools.buffer.FloatDataBuffer;
import org.tensorflow.tools.buffer.IntDataBuffer;
import org.tensorflow.tools.buffer.LongDataBuffer;
import org.tensorflow.tools.ndarray.BooleanNdArray;
import org.tensorflow.tools.ndarray.ByteNdArray;
import org.tensorflow.tools.ndarray.DoubleNdArray;
import org.tensorflow.tools.ndarray.FloatNdArray;
import org.tensorflow.tools.ndarray.IntNdArray;
import org.tensorflow.tools.ndarray.LongNdArray;
import org.tensorflow.tools.ndarray.NdArray;
import org.tensorflow.tools.ndarray.NdArrays;
import org.tensorflow.tools.ndarray.StdArrays;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TFloat64;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.TUint8;
import org.tensorflow.types.family.TType;

public final class Constant<T extends TType>
extends RawOp
implements Operand<T> {
    private final Output<T> output;

    public static Constant<TInt32> scalarOf(Scope scope, int data) {
        try (Tensor<TInt32> value = TInt32.scalarOf(data);){
            Constant<TInt32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt32> vectorOf(Scope scope, int[] data) {
        try (Tensor<TInt32> value = TInt32.vectorOf(data);){
            Constant<TInt32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt32> arrayOf(Scope scope, int ... data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        return Constant.vectorOf(scope, data);
    }

    public static Constant<TInt32> tensorOf(Scope scope, int[][] data) {
        try (Tensor<TInt32> value = TInt32.tensorOf(StdArrays.shapeOf(data), (TInt32 t) -> StdArrays.copyTo((IntNdArray)t, data));){
            Constant<TInt32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt32> tensorOf(Scope scope, int[][][] data) {
        try (Tensor<TInt32> value = TInt32.tensorOf(StdArrays.shapeOf(data), (TInt32 t) -> StdArrays.copyTo((IntNdArray)t, data));){
            Constant<TInt32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt32> tensorOf(Scope scope, int[][][][] data) {
        try (Tensor<TInt32> value = TInt32.tensorOf(StdArrays.shapeOf(data), (TInt32 t) -> StdArrays.copyTo((IntNdArray)t, data));){
            Constant<TInt32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt32> tensorOf(Scope scope, int[][][][][] data) {
        try (Tensor<TInt32> value = TInt32.tensorOf(StdArrays.shapeOf(data), (TInt32 t) -> StdArrays.copyTo((IntNdArray)t, data));){
            Constant<TInt32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt32> tensorOf(Scope scope, int[][][][][][] data) {
        try (Tensor<TInt32> value = TInt32.tensorOf(StdArrays.shapeOf(data), (TInt32 t) -> StdArrays.copyTo((IntNdArray)t, data));){
            Constant<TInt32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt32> tensorOf(Scope scope, IntNdArray data) {
        try (Tensor<TInt32> value = TInt32.tensorOf(data);){
            Constant<TInt32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt32> tensorOf(Scope scope, Shape shape, IntDataBuffer data) {
        try (Tensor<TInt32> value = TInt32.tensorOf(shape, data);){
            Constant<TInt32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat32> scalarOf(Scope scope, float data) {
        try (Tensor<TFloat32> value = TFloat32.scalarOf(data);){
            Constant<TFloat32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat32> vectorOf(Scope scope, float[] data) {
        try (Tensor<TFloat32> value = TFloat32.vectorOf(data);){
            Constant<TFloat32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat32> arrayOf(Scope scope, float ... data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        return Constant.vectorOf(scope, data);
    }

    public static Constant<TFloat32> tensorOf(Scope scope, float[][] data) {
        try (Tensor<TFloat32> value = TFloat32.tensorOf(StdArrays.shapeOf(data), (TFloat32 t) -> StdArrays.copyTo((FloatNdArray)t, data));){
            Constant<TFloat32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat32> tensorOf(Scope scope, float[][][] data) {
        try (Tensor<TFloat32> value = TFloat32.tensorOf(StdArrays.shapeOf(data), (TFloat32 t) -> StdArrays.copyTo((FloatNdArray)t, data));){
            Constant<TFloat32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat32> tensorOf(Scope scope, float[][][][] data) {
        try (Tensor<TFloat32> value = TFloat32.tensorOf(StdArrays.shapeOf(data), (TFloat32 t) -> StdArrays.copyTo((FloatNdArray)t, data));){
            Constant<TFloat32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat32> tensorOf(Scope scope, float[][][][][] data) {
        try (Tensor<TFloat32> value = TFloat32.tensorOf(StdArrays.shapeOf(data), (TFloat32 t) -> StdArrays.copyTo((FloatNdArray)t, data));){
            Constant<TFloat32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat32> tensorOf(Scope scope, float[][][][][][] data) {
        try (Tensor<TFloat32> value = TFloat32.tensorOf(StdArrays.shapeOf(data), (TFloat32 t) -> StdArrays.copyTo((FloatNdArray)t, data));){
            Constant<TFloat32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat32> tensorOf(Scope scope, FloatNdArray data) {
        try (Tensor<TFloat32> value = TFloat32.tensorOf(data);){
            Constant<TFloat32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat32> tensorOf(Scope scope, Shape shape, FloatDataBuffer data) {
        try (Tensor<TFloat32> value = TFloat32.tensorOf(shape, data);){
            Constant<TFloat32> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat64> scalarOf(Scope scope, double data) {
        try (Tensor<TFloat64> value = TFloat64.scalarOf(data);){
            Constant<TFloat64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat64> vectorOf(Scope scope, double[] data) {
        try (Tensor<TFloat64> value = TFloat64.vectorOf(data);){
            Constant<TFloat64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat64> arrayOf(Scope scope, double ... data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        return Constant.vectorOf(scope, data);
    }

    public static Constant<TFloat64> tensorOf(Scope scope, double[][] data) {
        try (Tensor<TFloat64> value = TFloat64.tensorOf(StdArrays.shapeOf(data), (TFloat64 t) -> StdArrays.copyTo((DoubleNdArray)t, data));){
            Constant<TFloat64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat64> tensorOf(Scope scope, double[][][] data) {
        try (Tensor<TFloat64> value = TFloat64.tensorOf(StdArrays.shapeOf(data), (TFloat64 t) -> StdArrays.copyTo((DoubleNdArray)t, data));){
            Constant<TFloat64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat64> tensorOf(Scope scope, double[][][][] data) {
        try (Tensor<TFloat64> value = TFloat64.tensorOf(StdArrays.shapeOf(data), (TFloat64 t) -> StdArrays.copyTo((DoubleNdArray)t, data));){
            Constant<TFloat64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat64> tensorOf(Scope scope, double[][][][][] data) {
        try (Tensor<TFloat64> value = TFloat64.tensorOf(StdArrays.shapeOf(data), (TFloat64 t) -> StdArrays.copyTo((DoubleNdArray)t, data));){
            Constant<TFloat64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat64> tensorOf(Scope scope, double[][][][][][] data) {
        try (Tensor<TFloat64> value = TFloat64.tensorOf(StdArrays.shapeOf(data), (TFloat64 t) -> StdArrays.copyTo((DoubleNdArray)t, data));){
            Constant<TFloat64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat64> tensorOf(Scope scope, DoubleNdArray data) {
        try (Tensor<TFloat64> value = TFloat64.tensorOf(data);){
            Constant<TFloat64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TFloat64> tensorOf(Scope scope, Shape shape, DoubleDataBuffer data) {
        try (Tensor<TFloat64> value = TFloat64.tensorOf(shape, data);){
            Constant<TFloat64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt64> scalarOf(Scope scope, long data) {
        try (Tensor<TInt64> value = TInt64.scalarOf(data);){
            Constant<TInt64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt64> vectorOf(Scope scope, long[] data) {
        try (Tensor<TInt64> value = TInt64.vectorOf(data);){
            Constant<TInt64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt64> tensorOf(Scope scope, long[][] data) {
        try (Tensor<TInt64> value = TInt64.tensorOf(StdArrays.shapeOf(data), (TInt64 t) -> StdArrays.copyTo((LongNdArray)t, data));){
            Constant<TInt64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt64> arrayOf(Scope scope, long ... data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        return Constant.vectorOf(scope, data);
    }

    public static Constant<TInt64> tensorOf(Scope scope, long[][][] data) {
        try (Tensor<TInt64> value = TInt64.tensorOf(StdArrays.shapeOf(data), (TInt64 t) -> StdArrays.copyTo((LongNdArray)t, data));){
            Constant<TInt64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt64> tensorOf(Scope scope, long[][][][] data) {
        try (Tensor<TInt64> value = TInt64.tensorOf(StdArrays.shapeOf(data), (TInt64 t) -> StdArrays.copyTo((LongNdArray)t, data));){
            Constant<TInt64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt64> tensorOf(Scope scope, long[][][][][] data) {
        try (Tensor<TInt64> value = TInt64.tensorOf(StdArrays.shapeOf(data), (TInt64 t) -> StdArrays.copyTo((LongNdArray)t, data));){
            Constant<TInt64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt64> tensorOf(Scope scope, long[][][][][][] data) {
        try (Tensor<TInt64> value = TInt64.tensorOf(StdArrays.shapeOf(data), (TInt64 t) -> StdArrays.copyTo((LongNdArray)t, data));){
            Constant<TInt64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt64> tensorOf(Scope scope, LongNdArray data) {
        try (Tensor<TInt64> value = TInt64.tensorOf(data);){
            Constant<TInt64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt64> tensorOf(Scope scope, Shape shape, LongDataBuffer data) {
        try (Tensor<TInt64> value = TInt64.tensorOf(shape, data);){
            Constant<TInt64> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TBool> scalarOf(Scope scope, boolean data) {
        try (Tensor<TBool> value = TBool.scalarOf(data);){
            Constant<TBool> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TBool> vectorOf(Scope scope, boolean[] data) {
        try (Tensor<TBool> value = TBool.vectorOf(data);){
            Constant<TBool> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TBool> arrayOf(Scope scope, boolean ... data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        return Constant.vectorOf(scope, data);
    }

    public static Constant<TBool> tensorOf(Scope scope, boolean[][] data) {
        try (Tensor<TBool> value = TBool.tensorOf(StdArrays.shapeOf(data), (TBool t) -> StdArrays.copyTo((BooleanNdArray)t, data));){
            Constant<TBool> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TBool> tensorOf(Scope scope, boolean[][][] data) {
        try (Tensor<TBool> value = TBool.tensorOf(StdArrays.shapeOf(data), (TBool t) -> StdArrays.copyTo((BooleanNdArray)t, data));){
            Constant<TBool> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TBool> tensorOf(Scope scope, boolean[][][][] data) {
        try (Tensor<TBool> value = TBool.tensorOf(StdArrays.shapeOf(data), (TBool t) -> StdArrays.copyTo((BooleanNdArray)t, data));){
            Constant<TBool> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TBool> tensorOf(Scope scope, boolean[][][][][] data) {
        try (Tensor<TBool> value = TBool.tensorOf(StdArrays.shapeOf(data), (TBool t) -> StdArrays.copyTo((BooleanNdArray)t, data));){
            Constant<TBool> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TBool> tensorOf(Scope scope, boolean[][][][][][] data) {
        try (Tensor<TBool> value = TBool.tensorOf(StdArrays.shapeOf(data), (TBool t) -> StdArrays.copyTo((BooleanNdArray)t, data));){
            Constant<TBool> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TBool> tensorOf(Scope scope, BooleanNdArray data) {
        try (Tensor<TBool> value = TBool.tensorOf(data);){
            Constant<TBool> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TBool> tensorOf(Scope scope, Shape shape, BooleanDataBuffer data) {
        try (Tensor<TBool> value = TBool.tensorOf(shape, data);){
            Constant<TBool> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TUint8> scalarOf(Scope scope, byte data) {
        try (Tensor<TUint8> value = TUint8.scalarOf(data);){
            Constant<TUint8> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TUint8> vectorOf(Scope scope, byte[] data) {
        try (Tensor<TUint8> value = TUint8.vectorOf(data);){
            Constant<TUint8> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TUint8> arrayOf(Scope scope, byte ... data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        return Constant.vectorOf(scope, data);
    }

    public static Constant<TUint8> tensorOf(Scope scope, byte[][] data) {
        try (Tensor<TUint8> value = TUint8.tensorOf(StdArrays.shapeOf(data), (TUint8 d) -> StdArrays.copyTo((ByteNdArray)d, data));){
            Constant<TUint8> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TUint8> tensorOf(Scope scope, byte[][][] data) {
        try (Tensor<TUint8> value = TUint8.tensorOf(StdArrays.shapeOf(data), (TUint8 d) -> StdArrays.copyTo((ByteNdArray)d, data));){
            Constant<TUint8> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TUint8> tensorOf(Scope scope, byte[][][][] data) {
        try (Tensor<TUint8> value = TUint8.tensorOf(StdArrays.shapeOf(data), (TUint8 d) -> StdArrays.copyTo((ByteNdArray)d, data));){
            Constant<TUint8> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TUint8> tensorOf(Scope scope, byte[][][][][] data) {
        try (Tensor<TUint8> value = TUint8.tensorOf(StdArrays.shapeOf(data), (TUint8 d) -> StdArrays.copyTo((ByteNdArray)d, data));){
            Constant<TUint8> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TUint8> tensorOf(Scope scope, byte[][][][][][] data) {
        try (Tensor<TUint8> value = TUint8.tensorOf(StdArrays.shapeOf(data), (TUint8 d) -> StdArrays.copyTo((ByteNdArray)d, data));){
            Constant<TUint8> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TUint8> tensorOf(Scope scope, ByteNdArray data) {
        try (Tensor<TUint8> value = TUint8.tensorOf(data);){
            Constant<TUint8> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TUint8> tensorOf(Scope scope, Shape shape, ByteDataBuffer data) {
        try (Tensor<TUint8> value = TUint8.tensorOf(shape, data);){
            Constant<TUint8> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static <T extends TType> Constant<T> tensorOf(Scope scope, DataType<T> type, Shape shape, ByteDataBuffer data) {
        try (Tensor<T> value = Tensor.of(type, shape, data);){
            Constant<T> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TString> scalarOf(Scope scope, String data) {
        try (Tensor<TString> value = TString.scalarOf(data);){
            Constant<TString> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TString> scalarOf(Scope scope, Charset charset, String data) {
        try (Tensor<TString> value = TString.tensorOf(charset, NdArrays.scalarOfObject(data));){
            Constant<TString> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TString> vectorOf(Scope scope, String[] data) {
        NdArray<String> src = NdArrays.vectorOfObjects(data);
        try (Tensor<TString> value = TString.tensorOf(src);){
            Constant<TString> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TString> vectorOf(Scope scope, Charset charset, String[] data) {
        try (Tensor<TString> value = TString.tensorOf(charset, NdArrays.vectorOfObjects(data));){
            Constant<TString> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TString> arrayOf(Scope scope, String ... data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        return Constant.vectorOf(scope, data);
    }

    public static Constant<TString> arrayOf(Scope scope, Charset charset, String ... data) {
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        return Constant.vectorOf(scope, charset, data);
    }

    public static Constant<TString> tensorOf(Scope scope, String[][] data) {
        NdArray<String> src = NdArrays.ofObjects(String.class, StdArrays.shapeOf(data));
        StdArrays.copyTo(src, data);
        try (Tensor<TString> value = TString.tensorOf(src);){
            Constant<TString> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TString> tensorOf(Scope scope, String[][][] data) {
        NdArray<String> src = NdArrays.ofObjects(String.class, StdArrays.shapeOf(data));
        StdArrays.copyTo(src, data);
        try (Tensor<TString> value = TString.tensorOf(src);){
            Constant<TString> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TString> tensorOf(Scope scope, String[][][][] data) {
        NdArray<String> src = NdArrays.ofObjects(String.class, StdArrays.shapeOf(data));
        StdArrays.copyTo(src, data);
        try (Tensor<TString> value = TString.tensorOf(src);){
            Constant<TString> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TString> tensorOf(Scope scope, String[][][][][] data) {
        NdArray<String> src = NdArrays.ofObjects(String.class, StdArrays.shapeOf(data));
        StdArrays.copyTo(src, data);
        try (Tensor<TString> value = TString.tensorOf(src);){
            Constant<TString> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TString> tensorOf(Scope scope, String[][][][][][] data) {
        NdArray<String> src = NdArrays.ofObjects(String.class, StdArrays.shapeOf(data));
        StdArrays.copyTo(src, data);
        try (Tensor<TString> value = TString.tensorOf(src);){
            Constant<TString> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TString> tensorOf(Scope scope, NdArray<String> data) {
        try (Tensor<TString> value = TString.tensorOf(data);){
            Constant<TString> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TString> tensorOf(Scope scope, Charset charset, NdArray<String> data) {
        try (Tensor<TString> value = TString.tensorOf(charset, data);){
            Constant<TString> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TString> tensorOf(Scope scope, Shape shape, DataBuffer<String> data) {
        try (Tensor<TString> value = TString.tensorOf(shape, data);){
            Constant<TString> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TString> tensorOf(Scope scope, Charset charset, Shape shape, DataBuffer<String> data) {
        try (Tensor<TString> value = TString.tensorOf(charset, shape, data);){
            Constant<TString> constant = Constant.create(scope, value);
            return constant;
        }
    }

    public static Constant<TInt64> tensorOf(Scope scope, Shape shape) {
        return Constant.vectorOf(scope, shape.asArray());
    }

    public static <T extends TType> Constant<T> create(Scope scope, Tensor<T> tensor) {
        return new Constant<T>(scope.env().opBuilder("Const", scope.makeOpName("Const")).setAttr("value", tensor).setAttr("dtype", tensor.dataType()).build());
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private Constant(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }
}

