/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SpaceToBatch", inputsClass=Inputs.class)
public final class SpaceToBatch<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "SpaceToBatch";
    private Output<T> output;

    public SpaceToBatch(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> SpaceToBatch<T> create(Scope scope, Operand<T> input, Operand<? extends TNumber> paddings, Long blockSize) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(paddings.asOutput());
        opBuilder.setAttr("block_size", blockSize);
        return new SpaceToBatch<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=SpaceToBatch.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<SpaceToBatch<T>> {
        public final Operand<T> input;
        public final Operand<? extends TNumber> paddings;
        public final DataType T;
        public final DataType Tpaddings;
        public final long blockSize;

        public Inputs(GraphOperation op) {
            super(new SpaceToBatch(op), op, Arrays.asList("T", "Tpaddings", "block_size"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.paddings = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tpaddings = op.attributes().getAttrType("Tpaddings");
            this.blockSize = op.attributes().getAttrInt("block_size");
        }
    }
}

