/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="ImageProjectiveTransformV3", inputsClass=Inputs.class)
public final class ImageProjectiveTransformV3<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "ImageProjectiveTransformV3";
    private Output<T> transformedImages;

    public ImageProjectiveTransformV3(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.transformedImages = operation.output(outputIdx++);
    }

    public static <T extends TNumber> ImageProjectiveTransformV3<T> create(Scope scope, Operand<T> images, Operand<TFloat32> transforms, Operand<TInt32> outputShape, Operand<TFloat32> fillValue, String interpolation, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(images.asOutput());
        opBuilder.addInput(transforms.asOutput());
        opBuilder.addInput(outputShape.asOutput());
        opBuilder.addInput(fillValue.asOutput());
        opBuilder.setAttr("interpolation", interpolation);
        if (options != null) {
            for (Options opts : options) {
                if (opts.fillMode == null) continue;
                opBuilder.setAttr("fill_mode", opts.fillMode);
            }
        }
        return new ImageProjectiveTransformV3<T>(opBuilder.build());
    }

    public static Options fillMode(String fillMode) {
        return new Options().fillMode(fillMode);
    }

    public Output<T> transformedImages() {
        return this.transformedImages;
    }

    @Override
    public Output<T> asOutput() {
        return this.transformedImages;
    }

    @OpInputsMetadata(outputsClass=ImageProjectiveTransformV3.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<ImageProjectiveTransformV3<T>> {
        public final Operand<T> images;
        public final Operand<TFloat32> transforms;
        public final Operand<TInt32> outputShape;
        public final Operand<TFloat32> fillValue;
        public final DataType dtype;
        public final String interpolation;
        public final String fillMode;

        public Inputs(GraphOperation op) {
            super(new ImageProjectiveTransformV3(op), op, Arrays.asList("dtype", "interpolation", "fill_mode"));
            int inputIndex = 0;
            this.images = op.input(inputIndex++);
            this.transforms = op.input(inputIndex++);
            this.outputShape = op.input(inputIndex++);
            this.fillValue = op.input(inputIndex++);
            this.dtype = op.attributes().getAttrType("dtype");
            this.interpolation = op.attributes().getAttrString("interpolation");
            this.fillMode = op.attributes().getAttrString("fill_mode");
        }
    }

    public static class Options {
        private String fillMode;

        private Options() {
        }

        public Options fillMode(String fillMode) {
            this.fillMode = fillMode;
            return this;
        }
    }
}

