/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.Operand;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.xla.AssignVariableConcatND;
import org.tensorflow.op.xla.ConcatND;
import org.tensorflow.op.xla.ReadVariableSplitND;
import org.tensorflow.op.xla.SplitND;
import org.tensorflow.op.xla.XlaHostCompute;
import org.tensorflow.op.xla.XlaRecvFromHost;
import org.tensorflow.op.xla.XlaRecvTPUEmbeddingActivations;
import org.tensorflow.op.xla.XlaRecvTPUEmbeddingDeduplicationData;
import org.tensorflow.op.xla.XlaSendTPUEmbeddingGradients;
import org.tensorflow.op.xla.XlaSendToHost;
import org.tensorflow.op.xla.XlaSparseCoreAdagrad;
import org.tensorflow.op.xla.XlaSparseCoreAdagradMomentum;
import org.tensorflow.op.xla.XlaSparseCoreAdam;
import org.tensorflow.op.xla.XlaSparseCoreFtrl;
import org.tensorflow.op.xla.XlaSparseCoreSgd;
import org.tensorflow.op.xla.XlaSparseDenseMatmul;
import org.tensorflow.op.xla.XlaSparseDenseMatmulGradWithAdagradAndCsrInput;
import org.tensorflow.op.xla.XlaSparseDenseMatmulGradWithAdagradMomentumAndCsrInput;
import org.tensorflow.op.xla.XlaSparseDenseMatmulGradWithAdamAndCsrInput;
import org.tensorflow.op.xla.XlaSparseDenseMatmulGradWithFtrlAndCsrInput;
import org.tensorflow.op.xla.XlaSparseDenseMatmulGradWithSgdAndCsrInput;
import org.tensorflow.op.xla.XlaSparseDenseMatmulWithCsrInput;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

public final class XlaOps {
    private final Scope scope;
    private final Ops ops;

    XlaOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public AssignVariableConcatND assignVariableConcatND(Operand<? extends TType> resource, Iterable<Operand<? extends TType>> inputs, List<Long> numConcats, AssignVariableConcatND.Options ... options) {
        return AssignVariableConcatND.create(this.scope, resource, inputs, numConcats, options);
    }

    public <T extends TType> ConcatND<T> concatND(Iterable<Operand<T>> inputs, List<Long> numConcats, ConcatND.Options ... options) {
        return ConcatND.create(this.scope, inputs, numConcats, options);
    }

    public <T extends TType> ReadVariableSplitND<T> readVariableSplitND(Operand<? extends TType> resource, Class<T> T, Long N, List<Long> numSplits, ReadVariableSplitND.Options ... options) {
        return ReadVariableSplitND.create(this.scope, resource, T, N, numSplits, options);
    }

    public <T extends TType> SplitND<T> splitND(Operand<T> input, Long N, List<Long> numSplits, SplitND.Options ... options) {
        return SplitND.create(this.scope, input, N, numSplits, options);
    }

    public XlaHostCompute xlaHostCompute(Iterable<Operand<?>> inputs, List<Class<? extends TType>> Toutputs, List<String> ancestors, List<Shape> shapes, ConcreteFunction shapeInferenceGraph, String key, XlaHostCompute.Options ... options) {
        return XlaHostCompute.create(this.scope, inputs, Toutputs, ancestors, shapes, shapeInferenceGraph, key, options);
    }

    public <T extends TType> XlaRecvFromHost<T> xlaRecvFromHost(Class<T> Toutput, Shape shape, String key) {
        return XlaRecvFromHost.create(this.scope, Toutput, shape, key);
    }

    public XlaRecvTPUEmbeddingActivations xlaRecvTPUEmbeddingActivations(Operand<? extends TType> deduplicationData, Long numTables, String config) {
        return XlaRecvTPUEmbeddingActivations.create(this.scope, deduplicationData, numTables, config);
    }

    public XlaRecvTPUEmbeddingDeduplicationData xlaRecvTPUEmbeddingDeduplicationData(String config) {
        return XlaRecvTPUEmbeddingDeduplicationData.create(this.scope, config);
    }

    public XlaSendTPUEmbeddingGradients xlaSendTPUEmbeddingGradients(Iterable<Operand<TFloat32>> gradients, Iterable<Operand<TFloat32>> learningRates, Operand<? extends TType> deduplicationData, String config, XlaSendTPUEmbeddingGradients.Options ... options) {
        return XlaSendTPUEmbeddingGradients.create(this.scope, gradients, learningRates, deduplicationData, config, options);
    }

    public XlaSendToHost xlaSendToHost(Operand<? extends TType> input, String key) {
        return XlaSendToHost.create(this.scope, input, key);
    }

    public XlaSparseCoreAdagrad xlaSparseCoreAdagrad(Operand<TInt32> indices, Operand<TFloat32> gradient, Operand<TFloat32> learningRate, Operand<TFloat32> accumulator, Operand<TFloat32> embeddingTable, Long featureWidth) {
        return XlaSparseCoreAdagrad.create(this.scope, indices, gradient, learningRate, accumulator, embeddingTable, featureWidth);
    }

    public XlaSparseCoreAdagradMomentum xlaSparseCoreAdagradMomentum(Operand<TInt32> indices, Operand<TFloat32> gradient, Operand<TFloat32> learningRate, Operand<TFloat32> beta1, Operand<TFloat32> epsilon, Operand<TFloat32> accumulator, Operand<TFloat32> momentum, Operand<TFloat32> embeddingTable, Long featureWidth, Boolean useNesterov, Float beta2, Float exponent) {
        return XlaSparseCoreAdagradMomentum.create(this.scope, indices, gradient, learningRate, beta1, epsilon, accumulator, momentum, embeddingTable, featureWidth, useNesterov, beta2, exponent);
    }

    public XlaSparseCoreAdam xlaSparseCoreAdam(Operand<TFloat32> embeddingTable, Operand<TInt32> indices, Operand<TFloat32> gradient, Operand<TFloat32> learningRate, Operand<TFloat32> momentum, Operand<TFloat32> velocity, Operand<TFloat32> beta1, Operand<TFloat32> beta2, Operand<TFloat32> epsilon, Long featureWidth, Boolean useSumInsideSqrt) {
        return XlaSparseCoreAdam.create(this.scope, embeddingTable, indices, gradient, learningRate, momentum, velocity, beta1, beta2, epsilon, featureWidth, useSumInsideSqrt);
    }

    public XlaSparseCoreFtrl xlaSparseCoreFtrl(Operand<TFloat32> embeddingTable, Operand<TFloat32> accumulator, Operand<TFloat32> linear, Operand<TFloat32> learningRate, Operand<TInt32> indices, Operand<TFloat32> gradient, Operand<TFloat32> beta, Operand<TFloat32> learningRatePower, Operand<TFloat32> l2RegularizationStrength, Long featureWidth, Boolean multiplyLinearByLearningRate, Float l1RegularizationStrength) {
        return XlaSparseCoreFtrl.create(this.scope, embeddingTable, accumulator, linear, learningRate, indices, gradient, beta, learningRatePower, l2RegularizationStrength, featureWidth, multiplyLinearByLearningRate, l1RegularizationStrength);
    }

    public XlaSparseCoreSgd xlaSparseCoreSgd(Operand<TInt32> indices, Operand<TFloat32> gradient, Operand<TFloat32> learningRate, Operand<TFloat32> embeddingTable, Long featureWidth) {
        return XlaSparseCoreSgd.create(this.scope, indices, gradient, learningRate, embeddingTable, featureWidth);
    }

    public XlaSparseDenseMatmul xlaSparseDenseMatmul(Operand<TInt32> rowIds, Operand<? extends TType> colIds, Operand<TFloat32> values, Operand<? extends TType> offsets, Operand<TFloat32> embeddingTable, Long maxIdsPerPartition, Long maxUniqueIdsPerPartition, Long inputSize) {
        return XlaSparseDenseMatmul.create(this.scope, rowIds, colIds, values, offsets, embeddingTable, maxIdsPerPartition, maxUniqueIdsPerPartition, inputSize);
    }

    public XlaSparseDenseMatmulGradWithAdagradAndCsrInput xlaSparseDenseMatmulGradWithAdagradAndCsrInput(Operand<TInt32> rowPointers, Operand<TInt32> sortedSampleIds, Operand<TInt32> sortedTokenIds, Operand<TFloat32> sortedGains, Operand<TFloat32> activationGradients, Operand<TFloat32> learningRate, Operand<TFloat32> embeddingTable, Operand<TFloat32> accumulator, Operand<TInt32> numMinibatchesPerPhysicalSparseCore, String tableName, XlaSparseDenseMatmulGradWithAdagradAndCsrInput.Options ... options) {
        return XlaSparseDenseMatmulGradWithAdagradAndCsrInput.create(this.scope, rowPointers, sortedSampleIds, sortedTokenIds, sortedGains, activationGradients, learningRate, embeddingTable, accumulator, numMinibatchesPerPhysicalSparseCore, tableName, options);
    }

    public XlaSparseDenseMatmulGradWithAdagradMomentumAndCsrInput xlaSparseDenseMatmulGradWithAdagradMomentumAndCsrInput(Operand<TInt32> rowPointers, Operand<TInt32> sortedSampleIds, Operand<TInt32> sortedTokenIds, Operand<TFloat32> sortedGains, Operand<TFloat32> activationGradients, Operand<TFloat32> learningRate, Operand<TFloat32> embeddingTable, Operand<TFloat32> accumulator, Operand<TFloat32> momenta, Operand<TInt32> numMinibatchesPerPhysicalSparseCore, Boolean useNesterov, Float exponent, Float beta1, Float beta2, Float epsilon, String tableName, XlaSparseDenseMatmulGradWithAdagradMomentumAndCsrInput.Options ... options) {
        return XlaSparseDenseMatmulGradWithAdagradMomentumAndCsrInput.create(this.scope, rowPointers, sortedSampleIds, sortedTokenIds, sortedGains, activationGradients, learningRate, embeddingTable, accumulator, momenta, numMinibatchesPerPhysicalSparseCore, useNesterov, exponent, beta1, beta2, epsilon, tableName, options);
    }

    public XlaSparseDenseMatmulGradWithAdamAndCsrInput xlaSparseDenseMatmulGradWithAdamAndCsrInput(Operand<TInt32> rowPointers, Operand<TInt32> sortedSampleIds, Operand<TInt32> sortedTokenIds, Operand<TFloat32> sortedGains, Operand<TFloat32> activationGradients, Operand<TFloat32> learningRate, Operand<TFloat32> embeddingTable, Operand<TFloat32> momenta, Operand<TFloat32> velocity, Operand<TInt32> numMinibatchesPerPhysicalSparseCore, Boolean useSumInsideSqrt, Float beta1, Float beta2, Float epsilon, String tableName, XlaSparseDenseMatmulGradWithAdamAndCsrInput.Options ... options) {
        return XlaSparseDenseMatmulGradWithAdamAndCsrInput.create(this.scope, rowPointers, sortedSampleIds, sortedTokenIds, sortedGains, activationGradients, learningRate, embeddingTable, momenta, velocity, numMinibatchesPerPhysicalSparseCore, useSumInsideSqrt, beta1, beta2, epsilon, tableName, options);
    }

    public XlaSparseDenseMatmulGradWithFtrlAndCsrInput xlaSparseDenseMatmulGradWithFtrlAndCsrInput(Operand<TInt32> rowPointers, Operand<TInt32> sortedSampleIds, Operand<TInt32> sortedTokenIds, Operand<TFloat32> sortedGains, Operand<TFloat32> activationGradients, Operand<TFloat32> learningRate, Operand<TFloat32> embeddingTable, Operand<TFloat32> accumulator, Operand<TFloat32> linear, Operand<TInt32> numMinibatchesPerPhysicalSparseCore, Boolean multiplyLinearByLearningRate, Float beta, Float learningRatePower, Float l1RegularizationStrength, Float l2RegularizationStrength, String tableName, XlaSparseDenseMatmulGradWithFtrlAndCsrInput.Options ... options) {
        return XlaSparseDenseMatmulGradWithFtrlAndCsrInput.create(this.scope, rowPointers, sortedSampleIds, sortedTokenIds, sortedGains, activationGradients, learningRate, embeddingTable, accumulator, linear, numMinibatchesPerPhysicalSparseCore, multiplyLinearByLearningRate, beta, learningRatePower, l1RegularizationStrength, l2RegularizationStrength, tableName, options);
    }

    public XlaSparseDenseMatmulGradWithSgdAndCsrInput xlaSparseDenseMatmulGradWithSgdAndCsrInput(Operand<TInt32> rowPointers, Operand<TInt32> sortedSampleIds, Operand<TInt32> sortedTokenIds, Operand<TFloat32> sortedGains, Operand<TFloat32> activationGradients, Operand<TFloat32> learningRate, Operand<TFloat32> embeddingTable, Operand<TInt32> numMinibatchesPerPhysicalSparseCore, String tableName, XlaSparseDenseMatmulGradWithSgdAndCsrInput.Options ... options) {
        return XlaSparseDenseMatmulGradWithSgdAndCsrInput.create(this.scope, rowPointers, sortedSampleIds, sortedTokenIds, sortedGains, activationGradients, learningRate, embeddingTable, numMinibatchesPerPhysicalSparseCore, tableName, options);
    }

    public XlaSparseDenseMatmulWithCsrInput xlaSparseDenseMatmulWithCsrInput(Operand<TInt32> rowPointers, Operand<TInt32> sortedSampleIds, Operand<TInt32> sortedTokenIds, Operand<TFloat32> sortedGains, Operand<TFloat32> embeddingTable, Operand<TInt32> numMinibatchesPerPhysicalSparseCore, Long inputSize, Float quantizationConfigLow, Float quantizationConfigHigh, Long quantizationConfigNumBuckets, String tableName) {
        return XlaSparseDenseMatmulWithCsrInput.create(this.scope, rowPointers, sortedSampleIds, sortedTokenIds, sortedGains, embeddingTable, numMinibatchesPerPhysicalSparseCore, inputSize, quantizationConfigLow, quantizationConfigHigh, quantizationConfigNumBuckets, tableName);
    }

    public final Ops ops() {
        return this.ops;
    }
}

