/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.AbstractOperation;
import org.tensorflow.Graph;
import org.tensorflow.GraphOperationAttributeInspector;
import org.tensorflow.Operand;
import org.tensorflow.OperationAttributeInspector;
import org.tensorflow.Output;
import org.tensorflow.Tensor;
import org.tensorflow.internal.c_api.TF_Graph;
import org.tensorflow.internal.c_api.TF_Input;
import org.tensorflow.internal.c_api.TF_Operation;
import org.tensorflow.internal.c_api.TF_Output;
import org.tensorflow.internal.c_api.TF_Status;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.proto.DataType;

public final class GraphOperation
extends AbstractOperation {
    private final AtomicReference<GraphOperationAttributeInspector> attrs = new AtomicReference<Object>(null);
    private final Graph graph;
    private final TF_Operation unsafeNativeHandle;

    GraphOperation(Graph g, TF_Operation unsafeNativeHandle) {
        this.graph = g;
        this.unsafeNativeHandle = unsafeNativeHandle;
    }

    @Override
    public String name() {
        try (Graph.Reference r = this.graph.ref();){
            String string = GraphOperation.name(this.getUnsafeNativeHandle());
            return string;
        }
    }

    @Override
    public String type() {
        try (Graph.Reference r = this.graph.ref();){
            String string = GraphOperation.type(this.getUnsafeNativeHandle());
            return string;
        }
    }

    @Override
    public Graph env() {
        try (Graph.Reference r = this.graph.ref();){
            Graph graph = this.graph;
            return graph;
        }
    }

    @Override
    public int numOutputs() {
        try (Graph.Reference r = this.graph.ref();){
            int n = GraphOperation.numOutputs(this.getUnsafeNativeHandle());
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int outputListLength(String name) {
        try (Graph.Reference r = this.graph.ref();){
            int n = GraphOperation.outputListLength(this.getUnsafeNativeHandle(), name);
            return n;
        }
    }

    public int hashCode() {
        return Long.valueOf(this.getUnsafeNativeHandle().address()).hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphOperation)) {
            return false;
        }
        GraphOperation that = (GraphOperation)o;
        if (this.graph != that.graph) {
            return false;
        }
        try (Graph.Reference r = this.graph.ref();){
            boolean bl = this.getUnsafeNativeHandle().equals((Object)that.getUnsafeNativeHandle());
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int inputListLength(String name) {
        try (Graph.Reference r = this.graph.ref();){
            int n = GraphOperation.inputListLength(this.getUnsafeNativeHandle(), name);
            return n;
        }
    }

    @Override
    TF_Operation getUnsafeNativeHandle(int outputIdx) {
        return this.getUnsafeNativeHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Shape shape(int outputIdx) {
        try (Graph.Reference r = this.graph.ref();){
            long[] shape = GraphOperation.shape(r.nativeHandle(), this.getUnsafeNativeHandle(), outputIdx);
            Shape shape2 = shape == null ? Shape.unknown() : Shape.of(shape);
            return shape2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    DataType dtype(int outputIdx) {
        try (Graph.Reference r = this.graph.ref();){
            DataType dataType = DataType.forNumber(GraphOperation.dtype(r.nativeHandle(), this.getUnsafeNativeHandle(), outputIdx));
            return dataType;
        }
    }

    @Override
    Tensor tensor(int outputIdx) {
        throw new IllegalStateException("Graph tensors must be fetched by running a session");
    }

    public String device() {
        return tensorflow.TF_OperationDevice(this.getCheckedNativeHandle()).getString();
    }

    public int numInputs() {
        GraphOperation.requireHandle(this.unsafeNativeHandle);
        return tensorflow.TF_OperationNumInputs(this.getUnsafeNativeHandle());
    }

    public Output<?> input(int idx) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException("Can't get input with index < 0.");
        }
        int numInputs = this.numInputs();
        if (idx >= numInputs) {
            throw new IndexOutOfBoundsException("Can't get input with index " + idx + ", this op only has " + numInputs + " inputs.");
        }
        try (PointerScope scope = new PointerScope();){
            TF_Input input = new TF_Input().oper(this.getUnsafeNativeHandle()).index(idx);
            TF_Output output = tensorflow.TF_OperationInput(input);
            Output output2 = new GraphOperation(this.graph, output.oper()).output(output.index());
            return output2;
        }
    }

    public OperationAttributeInspector attributes() {
        return this.attrs.updateAndGet(old -> old == null ? new GraphOperationAttributeInspector(this) : old);
    }

    public Output<?>[] inputList(int idx, int length) {
        Output[] inputs = new Output[length];
        for (int i = 0; i < length; ++i) {
            inputs[i] = this.input(idx + i);
        }
        return inputs;
    }

    public List<Operand<?>> inputs() {
        GraphOperation.requireHandle(this.unsafeNativeHandle);
        try (PointerScope scope = new PointerScope();){
            int numInputs = this.numInputs();
            TF_Output handles = new TF_Output(numInputs);
            tensorflow.TF_OperationAllInputs(this.getUnsafeNativeHandle(), handles, numInputs);
            ArrayList operands = new ArrayList(numInputs);
            for (int i = 0; i < numInputs; ++i) {
                TF_Output atPos = handles.position(i);
                TF_Operation op = atPos.oper();
                int index = atPos.index();
                String opName = tensorflow.TF_OperationName(op).getString();
                operands.add(this.graph.operation(opName).output(index));
            }
            ArrayList arrayList = operands;
            return arrayList;
        }
    }

    public int numConsumers(int index) {
        GraphOperation.requireHandle(this.unsafeNativeHandle);
        try (PointerScope scope = new PointerScope();){
            TF_Output output = new TF_Output().oper(this.getUnsafeNativeHandle()).index(index);
            int n = tensorflow.TF_OperationOutputNumConsumers(output);
            return n;
        }
    }

    public Set<GraphOperation> consumers(int index) {
        GraphOperation.requireHandle(this.unsafeNativeHandle);
        try (PointerScope scope = new PointerScope();){
            TF_Output output = new TF_Output().oper(this.getUnsafeNativeHandle()).index(index);
            int numConsumers = this.numConsumers(index);
            TF_Input handles = new TF_Input(numConsumers);
            tensorflow.TF_OperationOutputConsumers(output, handles, numConsumers);
            LinkedHashSet<GraphOperation> operands = new LinkedHashSet<GraphOperation>(numConsumers);
            for (int i = 0; i < numConsumers; ++i) {
                TF_Input atPos = handles.position(i);
                TF_Operation op = atPos.oper();
                String opName = tensorflow.TF_OperationName(op).getString();
                operands.add(this.graph.operation(opName));
            }
            LinkedHashSet<GraphOperation> linkedHashSet = operands;
            return linkedHashSet;
        }
    }

    public int numConsumers() {
        GraphOperation.requireHandle(this.unsafeNativeHandle);
        int all = 0;
        for (int i = 0; i < this.numOutputs(); ++i) {
            all += this.numConsumers(i);
        }
        return all;
    }

    public Set<GraphOperation> consumers() {
        GraphOperation.requireHandle(this.unsafeNativeHandle);
        LinkedHashSet<GraphOperation> all = new LinkedHashSet<GraphOperation>();
        for (int i = 0; i < this.numOutputs(); ++i) {
            all.addAll(this.consumers(i));
        }
        return all;
    }

    public int numControlInputs() {
        GraphOperation.requireHandle(this.unsafeNativeHandle);
        try (PointerScope scope = new PointerScope();){
            int n = tensorflow.TF_OperationNumControlInputs(this.getUnsafeNativeHandle());
            return n;
        }
    }

    public Set<GraphOperation> controlInputs() {
        GraphOperation.requireHandle(this.unsafeNativeHandle);
        try (PointerScope scope = new PointerScope();){
            int numInputs = this.numControlInputs();
            PointerPointer handles = new PointerPointer((long)numInputs);
            tensorflow.TF_OperationGetControlInputs(this.getUnsafeNativeHandle(), handles, numInputs);
            LinkedHashSet<GraphOperation> operands = new LinkedHashSet<GraphOperation>(numInputs);
            for (int i = 0; i < numInputs; ++i) {
                TF_Operation op = (TF_Operation)handles.get(TF_Operation.class, (long)i);
                String opName = tensorflow.TF_OperationName(op).getString();
                operands.add(this.graph.operation(opName));
            }
            LinkedHashSet<GraphOperation> linkedHashSet = operands;
            return linkedHashSet;
        }
    }

    public int numControlConsumers() {
        GraphOperation.requireHandle(this.unsafeNativeHandle);
        try (PointerScope scope = new PointerScope();){
            int n = tensorflow.TF_OperationNumControlOutputs(this.getUnsafeNativeHandle());
            return n;
        }
    }

    public Set<GraphOperation> controlConsumers() {
        GraphOperation.requireHandle(this.unsafeNativeHandle);
        try (PointerScope scope = new PointerScope();){
            int numConsumers = this.numControlConsumers();
            PointerPointer handles = new PointerPointer((long)numConsumers);
            tensorflow.TF_OperationGetControlOutputs(this.getUnsafeNativeHandle(), handles, numConsumers);
            LinkedHashSet<GraphOperation> operands = new LinkedHashSet<GraphOperation>(numConsumers);
            for (int i = 0; i < numConsumers; ++i) {
                TF_Operation op = (TF_Operation)handles.get(TF_Operation.class, (long)i);
                String opName = tensorflow.TF_OperationName(op).getString();
                operands.add(this.graph.operation(opName));
            }
            LinkedHashSet<GraphOperation> linkedHashSet = operands;
            return linkedHashSet;
        }
    }

    public TF_Operation getUnsafeNativeHandle() {
        return this.unsafeNativeHandle;
    }

    TF_Operation getCheckedNativeHandle() {
        GraphOperation.requireHandle(this.unsafeNativeHandle);
        return this.unsafeNativeHandle;
    }

    Graph graph() {
        return this.graph;
    }

    private static void requireHandle(Pointer handle) {
        if (handle == null || handle.isNull()) {
            throw new IllegalStateException("close() has been called on the Graph this Operation was a part of");
        }
    }

    private static String name(TF_Operation handle) {
        GraphOperation.requireHandle(handle);
        return tensorflow.TF_OperationName(handle).getString();
    }

    private static String type(TF_Operation handle) {
        GraphOperation.requireHandle(handle);
        return tensorflow.TF_OperationOpType(handle).getString();
    }

    private static int numOutputs(TF_Operation handle) {
        GraphOperation.requireHandle(handle);
        return tensorflow.TF_OperationNumOutputs(handle);
    }

    private static int outputListLength(TF_Operation handle, String name) {
        GraphOperation.requireHandle(handle);
        try (PointerScope scope = new PointerScope();){
            TF_Status status = TF_Status.newStatus();
            int result = tensorflow.TF_OperationOutputListLength(handle, name, status);
            status.throwExceptionIfNotOK();
            int n = result;
            return n;
        }
    }

    private static int inputListLength(TF_Operation handle, String name) {
        GraphOperation.requireHandle(handle);
        try (PointerScope scope = new PointerScope();){
            TF_Status status = TF_Status.newStatus();
            int result = tensorflow.TF_OperationInputListLength(handle, name, status);
            status.throwExceptionIfNotOK();
            int n = result;
            return n;
        }
    }

    private static long[] shape(TF_Graph graphHandle, TF_Operation opHandle, int outputIndex) {
        GraphOperation.requireHandle(graphHandle);
        GraphOperation.requireHandle(opHandle);
        int numOutputs = tensorflow.TF_OperationNumOutputs(opHandle);
        if (outputIndex < 0 || outputIndex >= numOutputs) {
            throw new IndexOutOfBoundsException("invalid output index (" + outputIndex + ") for an operation that has " + numOutputs + " outputs");
        }
        try (PointerScope scope = new PointerScope();){
            TF_Output output = new TF_Output().oper(opHandle).index(outputIndex);
            TF_Status status = TF_Status.newStatus();
            int numDims = tensorflow.TF_GraphGetTensorNumDims(graphHandle, output, status);
            status.throwExceptionIfNotOK();
            if (numDims < 0) {
                long[] lArray = null;
                return lArray;
            }
            long[] dims = new long[numDims];
            tensorflow.TF_GraphGetTensorShape(graphHandle, output, dims, numDims, status);
            status.throwExceptionIfNotOK();
            long[] lArray = dims;
            return lArray;
        }
    }

    private static int dtype(TF_Graph graphHandle, TF_Operation opHandle, int outputIndex) {
        GraphOperation.requireHandle(graphHandle);
        GraphOperation.requireHandle(opHandle);
        int numOutputs = tensorflow.TF_OperationNumOutputs(opHandle);
        if (outputIndex < 0 || outputIndex >= numOutputs) {
            throw new IndexOutOfBoundsException("invalid output index (" + outputIndex + ") for an operation that has " + numOutputs + " outputs");
        }
        try (PointerScope scope = new PointerScope();){
            int n = tensorflow.TF_OperationOutputType(new TF_Output().oper(opHandle).index(outputIndex));
            return n;
        }
    }
}

