/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.math;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="RequantizePerChannel", inputsClass=Inputs.class)
public final class RequantizePerChannel<U extends TNumber>
extends RawOp {
    public static final String OP_NAME = "RequantizePerChannel";
    private Output<U> output;
    private Output<TFloat32> outputMin;
    private Output<TFloat32> outputMax;

    public RequantizePerChannel(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.outputMin = operation.output(outputIdx++);
        this.outputMax = operation.output(outputIdx++);
    }

    public static <U extends TNumber> RequantizePerChannel<U> create(Scope scope, Operand<? extends TNumber> input, Operand<TFloat32> inputMin, Operand<TFloat32> inputMax, Operand<TFloat32> requestedOutputMin, Operand<TFloat32> requestedOutputMax, Class<U> outType) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(inputMin.asOutput());
        opBuilder.addInput(inputMax.asOutput());
        opBuilder.addInput(requestedOutputMin.asOutput());
        opBuilder.addInput(requestedOutputMax.asOutput());
        opBuilder.setAttr("out_type", Operands.toDataType(outType));
        return new RequantizePerChannel<U>(opBuilder.build());
    }

    public Output<U> output() {
        return this.output;
    }

    public Output<TFloat32> outputMin() {
        return this.outputMin;
    }

    public Output<TFloat32> outputMax() {
        return this.outputMax;
    }

    @OpInputsMetadata(outputsClass=RequantizePerChannel.class)
    public static class Inputs
    extends RawOpInputs<RequantizePerChannel<?>> {
        public final Operand<? extends TNumber> input;
        public final Operand<TFloat32> inputMin;
        public final Operand<TFloat32> inputMax;
        public final Operand<TFloat32> requestedOutputMin;
        public final Operand<TFloat32> requestedOutputMax;
        public final DataType T;
        public final DataType outType;

        public Inputs(GraphOperation op) {
            super(new RequantizePerChannel(op), op, Arrays.asList("T", "out_type"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.inputMin = op.input(inputIndex++);
            this.inputMax = op.input(inputIndex++);
            this.requestedOutputMin = op.input(inputIndex++);
            this.requestedOutputMax = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.outType = op.attributes().getAttrType("out_type");
        }
    }
}

