/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="BatchNormWithGlobalNormalizationGrad", inputsClass=Inputs.class)
public final class BatchNormWithGlobalNormalizationGrad<T extends TType>
extends RawOp {
    public static final String OP_NAME = "BatchNormWithGlobalNormalizationGrad";
    private Output<T> dx;
    private Output<T> dm;
    private Output<T> dv;
    private Output<T> db;
    private Output<T> dg;

    public BatchNormWithGlobalNormalizationGrad(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.dx = operation.output(outputIdx++);
        this.dm = operation.output(outputIdx++);
        this.dv = operation.output(outputIdx++);
        this.db = operation.output(outputIdx++);
        this.dg = operation.output(outputIdx++);
    }

    public static <T extends TType> BatchNormWithGlobalNormalizationGrad<T> create(Scope scope, Operand<T> t, Operand<T> m, Operand<T> v, Operand<T> gamma, Operand<T> backprop, Float varianceEpsilon, Boolean scaleAfterNormalization) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(t.asOutput());
        opBuilder.addInput(m.asOutput());
        opBuilder.addInput(v.asOutput());
        opBuilder.addInput(gamma.asOutput());
        opBuilder.addInput(backprop.asOutput());
        opBuilder.setAttr("variance_epsilon", varianceEpsilon.floatValue());
        opBuilder.setAttr("scale_after_normalization", scaleAfterNormalization);
        return new BatchNormWithGlobalNormalizationGrad<T>(opBuilder.build());
    }

    public Output<T> dx() {
        return this.dx;
    }

    public Output<T> dm() {
        return this.dm;
    }

    public Output<T> dv() {
        return this.dv;
    }

    public Output<T> db() {
        return this.db;
    }

    public Output<T> dg() {
        return this.dg;
    }

    @OpInputsMetadata(outputsClass=BatchNormWithGlobalNormalizationGrad.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<BatchNormWithGlobalNormalizationGrad<T>> {
        public final Operand<T> t;
        public final Operand<T> m;
        public final Operand<T> v;
        public final Operand<T> gamma;
        public final Operand<T> backprop;
        public final DataType T;
        public final float varianceEpsilon;
        public final boolean scaleAfterNormalization;

        public Inputs(GraphOperation op) {
            super(new BatchNormWithGlobalNormalizationGrad(op), op, Arrays.asList("T", "variance_epsilon", "scale_after_normalization"));
            int inputIndex = 0;
            this.t = op.input(inputIndex++);
            this.m = op.input(inputIndex++);
            this.v = op.input(inputIndex++);
            this.gamma = op.input(inputIndex++);
            this.backprop = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.varianceEpsilon = op.attributes().getAttrFloat("variance_epsilon");
            this.scaleAfterNormalization = op.attributes().getAttrBool("scale_after_normalization");
        }
    }
}

