/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="DynamicPartition", inputsClass=Inputs.class)
public final class DynamicPartition<T extends TType>
extends RawOp
implements Iterable<Operand<T>> {
    public static final String OP_NAME = "DynamicPartition";
    private List<Output<T>> outputs;

    public DynamicPartition(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputsLength = operation.outputListLength("outputs");
        this.outputs = Arrays.asList(operation.outputList(outputIdx, outputsLength));
        outputIdx += outputsLength;
    }

    public static <T extends TType> DynamicPartition<T> create(Scope scope, Operand<T> data, Operand<TInt32> partitions, Long numPartitions) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(data.asOutput());
        opBuilder.addInput(partitions.asOutput());
        opBuilder.setAttr("num_partitions", numPartitions);
        return new DynamicPartition<T>(opBuilder.build());
    }

    public List<Output<T>> outputs() {
        return this.outputs;
    }

    @Override
    public Iterator<Operand<T>> iterator() {
        return this.outputs.iterator();
    }

    @OpInputsMetadata(outputsClass=DynamicPartition.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<DynamicPartition<T>> {
        public final Operand<T> data;
        public final Operand<TInt32> partitions;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new DynamicPartition(op), op, Arrays.asList("T"));
            int inputIndex = 0;
            this.data = op.input(inputIndex++);
            this.partitions = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
        }
    }
}

