/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.audio;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TString;

@OpMetadata(opType="DecodeWav", inputsClass=Inputs.class)
public final class DecodeWav
extends RawOp {
    public static final String OP_NAME = "DecodeWav";
    private Output<TFloat32> audio;
    private Output<TInt32> sampleRate;

    public DecodeWav(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.audio = operation.output(outputIdx++);
        this.sampleRate = operation.output(outputIdx++);
    }

    public static DecodeWav create(Scope scope, Operand<TString> contents, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(contents.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.desiredChannels != null) {
                    opBuilder.setAttr("desired_channels", opts.desiredChannels);
                }
                if (opts.desiredSamples == null) continue;
                opBuilder.setAttr("desired_samples", opts.desiredSamples);
            }
        }
        return new DecodeWav(opBuilder.build());
    }

    public static Options desiredChannels(Long desiredChannels) {
        return new Options().desiredChannels(desiredChannels);
    }

    public static Options desiredSamples(Long desiredSamples) {
        return new Options().desiredSamples(desiredSamples);
    }

    public Output<TFloat32> audio() {
        return this.audio;
    }

    public Output<TInt32> sampleRate() {
        return this.sampleRate;
    }

    @OpInputsMetadata(outputsClass=DecodeWav.class)
    public static class Inputs
    extends RawOpInputs<DecodeWav> {
        public final Operand<TString> contents;
        public final long desiredChannels;
        public final long desiredSamples;

        public Inputs(GraphOperation op) {
            super(new DecodeWav(op), op, Arrays.asList("desired_channels", "desired_samples"));
            int inputIndex = 0;
            this.contents = op.input(inputIndex++);
            this.desiredChannels = op.attributes().getAttrInt("desired_channels");
            this.desiredSamples = op.attributes().getAttrInt("desired_samples");
        }
    }

    public static class Options {
        private Long desiredChannels;
        private Long desiredSamples;

        private Options() {
        }

        public Options desiredChannels(Long desiredChannels) {
            this.desiredChannels = desiredChannels;
            return this;
        }

        public Options desiredSamples(Long desiredSamples) {
            this.desiredSamples = desiredSamples;
            return this;
        }
    }
}

