/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SparseConcat", inputsClass=Inputs.class)
public final class SparseConcat<T extends TType>
extends RawOp {
    public static final String OP_NAME = "SparseConcat";
    private Output<TInt64> outputIndices;
    private Output<T> outputValues;
    private Output<TInt64> outputShape;

    public SparseConcat(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputIndices = operation.output(outputIdx++);
        this.outputValues = operation.output(outputIdx++);
        this.outputShape = operation.output(outputIdx++);
    }

    public static <T extends TType> SparseConcat<T> create(Scope scope, Iterable<Operand<TInt64>> indices, Iterable<Operand<T>> values, Iterable<Operand<TInt64>> shapes, Long concatDim) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(indices));
        opBuilder.addInputList(Operands.asOutputs(values));
        opBuilder.addInputList(Operands.asOutputs(shapes));
        opBuilder.setAttr("concat_dim", concatDim);
        return new SparseConcat<T>(opBuilder.build());
    }

    public Output<TInt64> outputIndices() {
        return this.outputIndices;
    }

    public Output<T> outputValues() {
        return this.outputValues;
    }

    public Output<TInt64> outputShape() {
        return this.outputShape;
    }

    @OpInputsMetadata(outputsClass=SparseConcat.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<SparseConcat<T>> {
        public final Iterable<Operand<TInt64>> indices;
        public final Iterable<Operand<T>> values;
        public final Iterable<Operand<TInt64>> shapes;
        public final long concatDim;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new SparseConcat(op), op, Arrays.asList("concat_dim", "T"));
            int inputIndex = 0;
            int indicesLength = op.inputListLength("indices");
            this.indices = Arrays.asList((Operand[])op.inputList(inputIndex, indicesLength));
            int valuesLength = op.inputListLength("values");
            this.values = Arrays.asList((Operand[])op.inputList(inputIndex += indicesLength, valuesLength));
            int shapesLength = op.inputListLength("shapes");
            this.shapes = Arrays.asList((Operand[])op.inputList(inputIndex += valuesLength, shapesLength));
            inputIndex += shapesLength;
            this.concatDim = op.attributes().getAttrInt("concat_dim");
            this.T = op.attributes().getAttrType("T");
        }
    }
}

