/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import java.util.function.Consumer;
import java.util.function.Function;
import org.tensorflow.internal.buffer.ByteSequenceProvider;
import org.tensorflow.internal.buffer.ByteSequenceTensorBuffer;
import org.tensorflow.internal.types.TStringMapper;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.types.TString;

public final class TStringInitializer<T>
implements Consumer<TString> {
    private final ByteSequenceProvider<T> byteSequenceProvider;

    public TStringInitializer(NdArray<T> source, Function<T, byte[]> byteExtractor) {
        this.byteSequenceProvider = new ByteSequenceProvider<T>(source, byteExtractor);
    }

    public long computeRequiredSize() {
        return ByteSequenceTensorBuffer.computeSize(this.byteSequenceProvider);
    }

    @Override
    public void accept(TString tensor) {
        ((TStringMapper.TStringInternal)tensor).init(this.byteSequenceProvider);
    }
}

