/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="Enter", inputsClass=Inputs.class)
public final class Enter<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "Enter";
    private Output<T> output;

    public Enter(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> Enter<T> create(Scope scope, Operand<T> data, String frameName, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(data.asOutput());
        opBuilder.setAttr("frame_name", frameName);
        if (options != null) {
            for (Options opts : options) {
                if (opts.isConstant != null) {
                    opBuilder.setAttr("is_constant", opts.isConstant);
                }
                if (opts.parallelIterations == null) continue;
                opBuilder.setAttr("parallel_iterations", opts.parallelIterations);
            }
        }
        return new Enter<T>(opBuilder.build());
    }

    public static Options isConstant(Boolean isConstant) {
        return new Options().isConstant(isConstant);
    }

    public static Options parallelIterations(Long parallelIterations) {
        return new Options().parallelIterations(parallelIterations);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Enter.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<Enter<T>> {
        public final Operand<T> data;
        public final DataType T;
        public final String frameName;
        public final boolean isConstant;
        public final long parallelIterations;

        public Inputs(GraphOperation op) {
            super(new Enter(op), op, Arrays.asList("T", "frame_name", "is_constant", "parallel_iterations"));
            int inputIndex = 0;
            this.data = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.frameName = op.attributes().getAttrString("frame_name");
            this.isConstant = op.attributes().getAttrBool("is_constant");
            this.parallelIterations = op.attributes().getAttrInt("parallel_iterations");
        }
    }

    public static class Options {
        private Boolean isConstant;
        private Long parallelIterations;

        private Options() {
        }

        public Options isConstant(Boolean isConstant) {
            this.isConstant = isConstant;
            return this;
        }

        public Options parallelIterations(Long parallelIterations) {
            this.parallelIterations = parallelIterations;
            return this;
        }
    }
}

