/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaSendTPUEmbeddingGradients", inputsClass=Inputs.class)
public final class XlaSendTPUEmbeddingGradients
extends RawOp {
    public static final String OP_NAME = "XlaSendTPUEmbeddingGradients";

    public XlaSendTPUEmbeddingGradients(Operation operation) {
        super(operation, OP_NAME);
    }

    public static XlaSendTPUEmbeddingGradients create(Scope scope, Iterable<Operand<TFloat32>> gradients, Iterable<Operand<TFloat32>> learningRates, Operand<? extends TType> deduplicationData, String config, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(gradients));
        opBuilder.addInputList(Operands.asOutputs(learningRates));
        opBuilder.addInput(deduplicationData.asOutput());
        opBuilder.setAttr("config", config);
        if (options != null) {
            for (Options opts : options) {
                if (opts.NumLearningRateTags == null) continue;
                opBuilder.setAttr("NumLearningRateTags", opts.NumLearningRateTags);
            }
        }
        return new XlaSendTPUEmbeddingGradients(opBuilder.build());
    }

    public static Options NumLearningRateTags(Long NumLearningRateTags) {
        return new Options().NumLearningRateTags(NumLearningRateTags);
    }

    @OpInputsMetadata(outputsClass=XlaSendTPUEmbeddingGradients.class)
    public static class Inputs
    extends RawOpInputs<XlaSendTPUEmbeddingGradients> {
        public final Iterable<Operand<TFloat32>> gradients;
        public final Iterable<Operand<TFloat32>> learningRates;
        public final Operand<? extends TType> deduplicationData;
        public final String config;

        public Inputs(GraphOperation op) {
            super(new XlaSendTPUEmbeddingGradients(op), op, Arrays.asList("config"));
            int inputIndex = 0;
            int gradientsLength = op.inputListLength("gradients");
            this.gradients = Arrays.asList((Operand[])op.inputList(inputIndex, gradientsLength));
            int learningRatesLength = op.inputListLength("learning_rates");
            this.learningRates = Arrays.asList((Operand[])op.inputList(inputIndex += gradientsLength, learningRatesLength));
            inputIndex += learningRatesLength;
            this.deduplicationData = op.input(inputIndex++);
            this.config = op.attributes().getAttrString("config");
        }
    }

    public static class Options {
        private Long NumLearningRateTags;

        private Options() {
        }

        public Options NumLearningRateTags(Long NumLearningRateTags) {
            this.NumLearningRateTags = NumLearningRateTags;
            return this;
        }
    }
}

