/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="OptimizeDatasetV2", inputsClass=Inputs.class)
public final class OptimizeDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "OptimizeDatasetV2";
    private Output<? extends TType> handle;

    public OptimizeDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static OptimizeDataset create(Scope scope, Operand<? extends TType> inputDataset, Operand<TString> optimizationsEnabled, Operand<TString> optimizationsDisabled, Operand<TString> optimizationsDefault, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "OptimizeDataset");
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(optimizationsEnabled.asOutput());
        opBuilder.addInput(optimizationsDisabled.asOutput());
        opBuilder.addInput(optimizationsDefault.asOutput());
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.optimizationConfigs == null) continue;
                String[] optimizationConfigsArray = new String[opts.optimizationConfigs.size()];
                for (int i = 0; i < optimizationConfigsArray.length; ++i) {
                    optimizationConfigsArray[i] = opts.optimizationConfigs.get(i);
                }
                opBuilder.setAttr("optimization_configs", optimizationConfigsArray);
            }
        }
        return new OptimizeDataset(opBuilder.build());
    }

    public static Options optimizationConfigs(List<String> optimizationConfigs) {
        return new Options().optimizationConfigs(optimizationConfigs);
    }

    public static Options optimizationConfigs(String ... optimizationConfigs) {
        return new Options().optimizationConfigs(optimizationConfigs);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=OptimizeDataset.class)
    public static class Inputs
    extends RawOpInputs<OptimizeDataset> {
        public final Operand<? extends TType> inputDataset;
        public final Operand<TString> optimizationsEnabled;
        public final Operand<TString> optimizationsDisabled;
        public final Operand<TString> optimizationsDefault;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;
        public final String[] optimizationConfigs;

        public Inputs(GraphOperation op) {
            super(new OptimizeDataset(op), op, Arrays.asList("output_types", "output_shapes", "optimization_configs"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            this.optimizationsEnabled = op.input(inputIndex++);
            this.optimizationsDisabled = op.input(inputIndex++);
            this.optimizationsDefault = op.input(inputIndex++);
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.optimizationConfigs = op.attributes().getAttrStringList("optimization_configs");
        }
    }

    public static class Options {
        private List<String> optimizationConfigs;

        private Options() {
        }

        public Options optimizationConfigs(List<String> optimizationConfigs) {
            this.optimizationConfigs = optimizationConfigs;
            return this;
        }

        public Options optimizationConfigs(String ... optimizationConfigs) {
            this.optimizationConfigs = Arrays.asList(optimizationConfigs);
            return this;
        }
    }
}

