/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="FixedLengthRecordDatasetV2", inputsClass=Inputs.class)
public final class FixedLengthRecordDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "FixedLengthRecordDatasetV2";
    private Output<? extends TType> handle;

    public FixedLengthRecordDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static FixedLengthRecordDataset create(Scope scope, Operand<TString> filenames, Operand<TInt64> headerBytes, Operand<TInt64> recordBytes, Operand<TInt64> footerBytes, Operand<TInt64> bufferSize, Operand<TString> compressionType, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "FixedLengthRecordDataset");
        opBuilder.addInput(filenames.asOutput());
        opBuilder.addInput(headerBytes.asOutput());
        opBuilder.addInput(recordBytes.asOutput());
        opBuilder.addInput(footerBytes.asOutput());
        opBuilder.addInput(bufferSize.asOutput());
        opBuilder.addInput(compressionType.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.metadata == null) continue;
                opBuilder.setAttr("metadata", opts.metadata);
            }
        }
        return new FixedLengthRecordDataset(opBuilder.build());
    }

    public static Options metadata(String metadata) {
        return new Options().metadata(metadata);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=FixedLengthRecordDataset.class)
    public static class Inputs
    extends RawOpInputs<FixedLengthRecordDataset> {
        public final Operand<TString> filenames;
        public final Operand<TInt64> headerBytes;
        public final Operand<TInt64> recordBytes;
        public final Operand<TInt64> footerBytes;
        public final Operand<TInt64> bufferSize;
        public final Operand<TString> compressionType;
        public final String metadata;

        public Inputs(GraphOperation op) {
            super(new FixedLengthRecordDataset(op), op, Arrays.asList("metadata"));
            int inputIndex = 0;
            this.filenames = op.input(inputIndex++);
            this.headerBytes = op.input(inputIndex++);
            this.recordBytes = op.input(inputIndex++);
            this.footerBytes = op.input(inputIndex++);
            this.bufferSize = op.input(inputIndex++);
            this.compressionType = op.input(inputIndex++);
            this.metadata = op.attributes().getAttrString("metadata");
        }
    }

    public static class Options {
        private String metadata;

        private Options() {
        }

        public Options metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }
    }
}

