/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.types;

import java.util.function.Consumer;
import org.tensorflow.SparseTensor;
import org.tensorflow.Tensor;
import org.tensorflow.internal.types.TUint8Mapper;
import org.tensorflow.ndarray.ByteNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.ByteDataBuffer;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.annotation.TensorType;
import org.tensorflow.types.family.TIntegral;

@TensorType(dataType=DataType.DT_UINT8, byteSize=1, mapperClass=TUint8Mapper.class)
public interface TUint8
extends ByteNdArray,
TIntegral {
    public static TUint8 scalarOf(byte value) {
        return Tensor.of(TUint8.class, Shape.scalar(), (T data) -> data.setByte(value, new long[0]));
    }

    public static TUint8 vectorOf(byte ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return Tensor.of(TUint8.class, Shape.of(values.length), (T data) -> StdArrays.copyTo(values, (ByteNdArray)data));
    }

    public static TUint8 tensorOf(NdArray<Byte> src) {
        return Tensor.of(TUint8.class, src.shape(), src::copyTo);
    }

    public static TUint8 tensorOf(Shape shape) {
        return Tensor.of(TUint8.class, shape);
    }

    public static TUint8 tensorOf(Shape shape, ByteDataBuffer data) {
        return Tensor.of(TUint8.class, shape, (T d) -> d.write(data));
    }

    public static TUint8 tensorOf(Shape shape, Consumer<TUint8> dataInit) {
        return Tensor.of(TUint8.class, shape, dataInit);
    }

    public static TUint8 sparseTensorOf(TInt64 indices, TUint8 values, TInt64 denseShape) {
        return SparseTensor.of(indices, values, denseShape).asTypedTensor();
    }
}

