/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaHostCompute", inputsClass=Inputs.class)
public final class XlaHostCompute
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "XlaHostCompute";
    private List<Output<?>> outputs;

    public XlaHostCompute(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputsLength = operation.outputListLength("outputs");
        this.outputs = Arrays.asList(operation.outputList(outputIdx, outputsLength));
        outputIdx += outputsLength;
    }

    public static XlaHostCompute create(Scope scope, Iterable<Operand<?>> inputs, List<Class<? extends TType>> Toutputs, List<String> ancestors, List<Shape> shapes, ConcreteFunction shapeInferenceGraph, String key, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(inputs));
        opBuilder.setAttr("Toutputs", Operands.toDataTypes(Toutputs));
        String[] ancestorsArray = new String[ancestors.size()];
        for (int i = 0; i < ancestorsArray.length; ++i) {
            ancestorsArray[i] = ancestors.get(i);
        }
        opBuilder.setAttr("ancestors", ancestorsArray);
        Shape[] shapesArray = new Shape[shapes.size()];
        for (int i = 0; i < shapesArray.length; ++i) {
            shapesArray[i] = shapes.get(i);
        }
        opBuilder.setAttr("shapes", shapesArray);
        opBuilder.setAttr("shape_inference_graph", shapeInferenceGraph);
        opBuilder.setAttr("key", key);
        if (options != null) {
            for (Options opts : options) {
                if (opts.sendKey != null) {
                    opBuilder.setAttr("send_key", opts.sendKey);
                }
                if (opts.recvKey != null) {
                    opBuilder.setAttr("recv_key", opts.recvKey);
                }
                if (opts.costEstimateNs != null) {
                    opBuilder.setAttr("cost_estimate_ns", opts.costEstimateNs);
                }
                if (opts.tpuCore == null) continue;
                opBuilder.setAttr("tpu_core", opts.tpuCore);
            }
        }
        return new XlaHostCompute(opBuilder.build());
    }

    public static Options sendKey(String sendKey) {
        return new Options().sendKey(sendKey);
    }

    public static Options recvKey(String recvKey) {
        return new Options().recvKey(recvKey);
    }

    public static Options costEstimateNs(Long costEstimateNs) {
        return new Options().costEstimateNs(costEstimateNs);
    }

    public static Options tpuCore(Long tpuCore) {
        return new Options().tpuCore(tpuCore);
    }

    public List<Output<?>> outputs() {
        return this.outputs;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.outputs.iterator();
    }

    @OpInputsMetadata(outputsClass=XlaHostCompute.class)
    public static class Inputs
    extends RawOpInputs<XlaHostCompute> {
        public final Iterable<Operand<?>> inputs;
        public final DataType[] Tinputs;
        public final DataType[] Toutputs;
        public final String[] ancestors;
        public final Shape[] shapes;
        public final String key;
        public final String sendKey;
        public final String recvKey;
        public final long costEstimateNs;
        public final long tpuCore;

        public Inputs(GraphOperation op) {
            super(new XlaHostCompute(op), op, Arrays.asList("Tinputs", "Toutputs", "ancestors", "shapes", "key", "send_key", "recv_key", "cost_estimate_ns", "tpu_core"));
            int inputIndex = 0;
            int inputsLength = op.inputListLength("inputs");
            this.inputs = Arrays.asList((Operand[])op.inputList(inputIndex, inputsLength));
            inputIndex += inputsLength;
            this.Tinputs = op.attributes().getAttrTypeList("Tinputs");
            this.Toutputs = op.attributes().getAttrTypeList("Toutputs");
            this.ancestors = op.attributes().getAttrStringList("ancestors");
            this.shapes = op.attributes().getAttrShapeList("shapes");
            this.key = op.attributes().getAttrString("key");
            this.sendKey = op.attributes().getAttrString("send_key");
            this.recvKey = op.attributes().getAttrString("recv_key");
            this.costEstimateNs = op.attributes().getAttrInt("cost_estimate_ns");
            this.tpuCore = op.attributes().getAttrInt("tpu_core");
        }
    }

    public static class Options {
        private String sendKey;
        private String recvKey;
        private Long costEstimateNs;
        private Long tpuCore;

        private Options() {
        }

        public Options sendKey(String sendKey) {
            this.sendKey = sendKey;
            return this;
        }

        public Options recvKey(String recvKey) {
            this.recvKey = recvKey;
            return this;
        }

        public Options costEstimateNs(Long costEstimateNs) {
            this.costEstimateNs = costEstimateNs;
            return this;
        }

        public Options tpuCore(Long tpuCore) {
            this.tpuCore = tpuCore;
            return this;
        }
    }
}

