/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SparseReorder", inputsClass=Inputs.class)
public final class SparseReorder<T extends TType>
extends RawOp {
    public static final String OP_NAME = "SparseReorder";
    private Output<TInt64> outputIndices;
    private Output<T> outputValues;

    public SparseReorder(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputIndices = operation.output(outputIdx++);
        this.outputValues = operation.output(outputIdx++);
    }

    public static <T extends TType> SparseReorder<T> create(Scope scope, Operand<TInt64> inputIndices, Operand<T> inputValues, Operand<TInt64> inputShape) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputIndices.asOutput());
        opBuilder.addInput(inputValues.asOutput());
        opBuilder.addInput(inputShape.asOutput());
        return new SparseReorder<T>(opBuilder.build());
    }

    public Output<TInt64> outputIndices() {
        return this.outputIndices;
    }

    public Output<T> outputValues() {
        return this.outputValues;
    }

    @OpInputsMetadata(outputsClass=SparseReorder.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<SparseReorder<T>> {
        public final Operand<TInt64> inputIndices;
        public final Operand<T> inputValues;
        public final Operand<TInt64> inputShape;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new SparseReorder(op), op, Arrays.asList("T"));
            int inputIndex = 0;
            this.inputIndices = op.input(inputIndex++);
            this.inputValues = op.input(inputIndex++);
            this.inputShape = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
        }
    }
}

