/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt64;

@OpMetadata(opType="FixedUnigramCandidateSampler", inputsClass=Inputs.class)
public final class FixedUnigramCandidateSampler
extends RawOp {
    public static final String OP_NAME = "FixedUnigramCandidateSampler";
    private Output<TInt64> sampledCandidates;
    private Output<TFloat32> trueExpectedCount;
    private Output<TFloat32> sampledExpectedCount;

    public FixedUnigramCandidateSampler(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.sampledCandidates = operation.output(outputIdx++);
        this.trueExpectedCount = operation.output(outputIdx++);
        this.sampledExpectedCount = operation.output(outputIdx++);
    }

    public static FixedUnigramCandidateSampler create(Scope scope, Operand<TInt64> trueClasses, Long numTrue, Long numSampled, Boolean unique, Long rangeMax, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(trueClasses.asOutput());
        opBuilder.setAttr("num_true", numTrue);
        opBuilder.setAttr("num_sampled", numSampled);
        opBuilder.setAttr("unique", unique);
        opBuilder.setAttr("range_max", rangeMax);
        if (options != null) {
            for (Options opts : options) {
                if (opts.vocabFile != null) {
                    opBuilder.setAttr("vocab_file", opts.vocabFile);
                }
                if (opts.distortion != null) {
                    opBuilder.setAttr("distortion", opts.distortion.floatValue());
                }
                if (opts.numReservedIds != null) {
                    opBuilder.setAttr("num_reserved_ids", opts.numReservedIds);
                }
                if (opts.numShards != null) {
                    opBuilder.setAttr("num_shards", opts.numShards);
                }
                if (opts.shard != null) {
                    opBuilder.setAttr("shard", opts.shard);
                }
                if (opts.unigrams != null) {
                    float[] unigramsArray = new float[opts.unigrams.size()];
                    for (int i = 0; i < unigramsArray.length; ++i) {
                        unigramsArray[i] = opts.unigrams.get(i).floatValue();
                    }
                    opBuilder.setAttr("unigrams", unigramsArray);
                }
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 == null) continue;
                opBuilder.setAttr("seed2", opts.seed2);
            }
        }
        return new FixedUnigramCandidateSampler(opBuilder.build());
    }

    public static Options vocabFile(String vocabFile) {
        return new Options().vocabFile(vocabFile);
    }

    public static Options distortion(Float distortion) {
        return new Options().distortion(distortion);
    }

    public static Options numReservedIds(Long numReservedIds) {
        return new Options().numReservedIds(numReservedIds);
    }

    public static Options numShards(Long numShards) {
        return new Options().numShards(numShards);
    }

    public static Options shard(Long shard) {
        return new Options().shard(shard);
    }

    public static Options unigrams(List<Float> unigrams) {
        return new Options().unigrams(unigrams);
    }

    public static Options unigrams(Float ... unigrams) {
        return new Options().unigrams(unigrams);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public Output<TInt64> sampledCandidates() {
        return this.sampledCandidates;
    }

    public Output<TFloat32> trueExpectedCount() {
        return this.trueExpectedCount;
    }

    public Output<TFloat32> sampledExpectedCount() {
        return this.sampledExpectedCount;
    }

    @OpInputsMetadata(outputsClass=FixedUnigramCandidateSampler.class)
    public static class Inputs
    extends RawOpInputs<FixedUnigramCandidateSampler> {
        public final Operand<TInt64> trueClasses;
        public final long numTrue;
        public final long numSampled;
        public final boolean unique;
        public final long rangeMax;
        public final String vocabFile;
        public final float distortion;
        public final long numReservedIds;
        public final long numShards;
        public final long shard;
        public final float[] unigrams;
        public final long seed;
        public final long seed2;

        public Inputs(GraphOperation op) {
            super(new FixedUnigramCandidateSampler(op), op, Arrays.asList("num_true", "num_sampled", "unique", "range_max", "vocab_file", "distortion", "num_reserved_ids", "num_shards", "shard", "unigrams", "seed", "seed2"));
            int inputIndex = 0;
            this.trueClasses = op.input(inputIndex++);
            this.numTrue = op.attributes().getAttrInt("num_true");
            this.numSampled = op.attributes().getAttrInt("num_sampled");
            this.unique = op.attributes().getAttrBool("unique");
            this.rangeMax = op.attributes().getAttrInt("range_max");
            this.vocabFile = op.attributes().getAttrString("vocab_file");
            this.distortion = op.attributes().getAttrFloat("distortion");
            this.numReservedIds = op.attributes().getAttrInt("num_reserved_ids");
            this.numShards = op.attributes().getAttrInt("num_shards");
            this.shard = op.attributes().getAttrInt("shard");
            this.unigrams = op.attributes().getAttrFloatList("unigrams");
            this.seed = op.attributes().getAttrInt("seed");
            this.seed2 = op.attributes().getAttrInt("seed2");
        }
    }

    public static class Options {
        private String vocabFile;
        private Float distortion;
        private Long numReservedIds;
        private Long numShards;
        private Long shard;
        private List<Float> unigrams;
        private Long seed;
        private Long seed2;

        private Options() {
        }

        public Options vocabFile(String vocabFile) {
            this.vocabFile = vocabFile;
            return this;
        }

        public Options distortion(Float distortion) {
            this.distortion = distortion;
            return this;
        }

        public Options numReservedIds(Long numReservedIds) {
            this.numReservedIds = numReservedIds;
            return this;
        }

        public Options numShards(Long numShards) {
            this.numShards = numShards;
            return this;
        }

        public Options shard(Long shard) {
            this.shard = shard;
            return this;
        }

        public Options unigrams(List<Float> unigrams) {
            this.unigrams = unigrams;
            return this;
        }

        public Options unigrams(Float ... unigrams) {
            this.unigrams = Arrays.asList(unigrams);
            return this;
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }
    }
}

