/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ReadVariableOp", inputsClass=Inputs.class)
public final class ReadVariableOp<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "ReadVariableOp";
    private Output<T> value;

    public ReadVariableOp(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.value = operation.output(outputIdx++);
    }

    public static <T extends TType> ReadVariableOp<T> create(Scope scope, Operand<? extends TType> resource, Class<T> dtype) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(resource.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        return new ReadVariableOp<T>(opBuilder.build());
    }

    public Output<T> value() {
        return this.value;
    }

    @Override
    public Output<T> asOutput() {
        return this.value;
    }

    @OpInputsMetadata(outputsClass=ReadVariableOp.class)
    public static class Inputs
    extends RawOpInputs<ReadVariableOp<?>> {
        public final Operand<? extends TType> resource;
        public final DataType dtype;

        public Inputs(GraphOperation op) {
            super(new ReadVariableOp(op), op, Arrays.asList("dtype"));
            int inputIndex = 0;
            this.resource = op.input(inputIndex++);
            this.dtype = op.attributes().getAttrType("dtype");
        }
    }
}

