/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="DTensorRestoreV2", inputsClass=Inputs.class)
public final class DTensorRestore
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "DTensorRestoreV2";
    private List<Output<?>> tensors;

    public DTensorRestore(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int tensorsLength = operation.outputListLength("tensors");
        this.tensors = Arrays.asList(operation.outputList(outputIdx, tensorsLength));
        outputIdx += tensorsLength;
    }

    public static DTensorRestore create(Scope scope, Operand<TString> prefix, Operand<TString> tensorNames, Operand<TString> shapeAndSlices, List<Shape> inputShapes, List<String> inputLayouts, List<Class<? extends TType>> dtypes) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "DTensorRestore");
        opBuilder.addInput(prefix.asOutput());
        opBuilder.addInput(tensorNames.asOutput());
        opBuilder.addInput(shapeAndSlices.asOutput());
        Shape[] inputShapesArray = new Shape[inputShapes.size()];
        for (int i = 0; i < inputShapesArray.length; ++i) {
            inputShapesArray[i] = inputShapes.get(i);
        }
        opBuilder.setAttr("input_shapes", inputShapesArray);
        String[] inputLayoutsArray = new String[inputLayouts.size()];
        for (int i = 0; i < inputLayoutsArray.length; ++i) {
            inputLayoutsArray[i] = inputLayouts.get(i);
        }
        opBuilder.setAttr("input_layouts", inputLayoutsArray);
        opBuilder.setAttr("dtypes", Operands.toDataTypes(dtypes));
        return new DTensorRestore(opBuilder.build());
    }

    public List<Output<?>> tensors() {
        return this.tensors;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.tensors.iterator();
    }

    @OpInputsMetadata(outputsClass=DTensorRestore.class)
    public static class Inputs
    extends RawOpInputs<DTensorRestore> {
        public final Operand<TString> prefix;
        public final Operand<TString> tensorNames;
        public final Operand<TString> shapeAndSlices;
        public final Shape[] inputShapes;
        public final String[] inputLayouts;
        public final DataType[] dtypes;

        public Inputs(GraphOperation op) {
            super(new DTensorRestore(op), op, Arrays.asList("input_shapes", "input_layouts", "dtypes"));
            int inputIndex = 0;
            this.prefix = op.input(inputIndex++);
            this.tensorNames = op.input(inputIndex++);
            this.shapeAndSlices = op.input(inputIndex++);
            this.inputShapes = op.attributes().getAttrShapeList("input_shapes");
            this.inputLayouts = op.attributes().getAttrStringList("input_layouts");
            this.dtypes = op.attributes().getAttrTypeList("dtypes");
        }
    }
}

