/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.summary;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TString;

@OpMetadata(opType="AudioSummaryV2", inputsClass=Inputs.class)
public final class AudioSummary
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "AudioSummaryV2";
    private Output<TString> summary;

    public AudioSummary(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.summary = operation.output(outputIdx++);
    }

    public static AudioSummary create(Scope scope, Operand<TString> tag, Operand<TFloat32> tensor, Operand<TFloat32> sampleRate, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "AudioSummary");
        opBuilder.addInput(tag.asOutput());
        opBuilder.addInput(tensor.asOutput());
        opBuilder.addInput(sampleRate.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.maxOutputs == null) continue;
                opBuilder.setAttr("max_outputs", opts.maxOutputs);
            }
        }
        return new AudioSummary(opBuilder.build());
    }

    public static Options maxOutputs(Long maxOutputs) {
        return new Options().maxOutputs(maxOutputs);
    }

    public Output<TString> summary() {
        return this.summary;
    }

    @Override
    public Output<TString> asOutput() {
        return this.summary;
    }

    @OpInputsMetadata(outputsClass=AudioSummary.class)
    public static class Inputs
    extends RawOpInputs<AudioSummary> {
        public final Operand<TString> tag;
        public final Operand<TFloat32> tensor;
        public final Operand<TFloat32> sampleRate;
        public final long maxOutputs;

        public Inputs(GraphOperation op) {
            super(new AudioSummary(op), op, Arrays.asList("max_outputs"));
            int inputIndex = 0;
            this.tag = op.input(inputIndex++);
            this.tensor = op.input(inputIndex++);
            this.sampleRate = op.input(inputIndex++);
            this.maxOutputs = op.attributes().getAttrInt("max_outputs");
        }
    }

    public static class Options {
        private Long maxOutputs;

        private Options() {
        }

        public Options maxOutputs(Long maxOutputs) {
            this.maxOutputs = maxOutputs;
            return this;
        }
    }
}

