/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SparseToSparseSetOperation", inputsClass=Inputs.class)
public final class SparseToSparseSetOperation<T extends TType>
extends RawOp {
    public static final String OP_NAME = "SparseToSparseSetOperation";
    private Output<TInt64> resultIndices;
    private Output<T> resultValues;
    private Output<TInt64> resultShape;

    public SparseToSparseSetOperation(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.resultIndices = operation.output(outputIdx++);
        this.resultValues = operation.output(outputIdx++);
        this.resultShape = operation.output(outputIdx++);
    }

    public static <T extends TType> SparseToSparseSetOperation<T> create(Scope scope, Operand<TInt64> set1Indices, Operand<T> set1Values, Operand<TInt64> set1Shape, Operand<TInt64> set2Indices, Operand<T> set2Values, Operand<TInt64> set2Shape, String setOperation, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(set1Indices.asOutput());
        opBuilder.addInput(set1Values.asOutput());
        opBuilder.addInput(set1Shape.asOutput());
        opBuilder.addInput(set2Indices.asOutput());
        opBuilder.addInput(set2Values.asOutput());
        opBuilder.addInput(set2Shape.asOutput());
        opBuilder.setAttr("set_operation", setOperation);
        if (options != null) {
            for (Options opts : options) {
                if (opts.validateIndices == null) continue;
                opBuilder.setAttr("validate_indices", opts.validateIndices);
            }
        }
        return new SparseToSparseSetOperation<T>(opBuilder.build());
    }

    public static Options validateIndices(Boolean validateIndices) {
        return new Options().validateIndices(validateIndices);
    }

    public Output<TInt64> resultIndices() {
        return this.resultIndices;
    }

    public Output<T> resultValues() {
        return this.resultValues;
    }

    public Output<TInt64> resultShape() {
        return this.resultShape;
    }

    @OpInputsMetadata(outputsClass=SparseToSparseSetOperation.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<SparseToSparseSetOperation<T>> {
        public final Operand<TInt64> set1Indices;
        public final Operand<T> set1Values;
        public final Operand<TInt64> set1Shape;
        public final Operand<TInt64> set2Indices;
        public final Operand<T> set2Values;
        public final Operand<TInt64> set2Shape;
        public final String setOperation;
        public final boolean validateIndices;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new SparseToSparseSetOperation(op), op, Arrays.asList("set_operation", "validate_indices", "T"));
            int inputIndex = 0;
            this.set1Indices = op.input(inputIndex++);
            this.set1Values = op.input(inputIndex++);
            this.set1Shape = op.input(inputIndex++);
            this.set2Indices = op.input(inputIndex++);
            this.set2Values = op.input(inputIndex++);
            this.set2Shape = op.input(inputIndex++);
            this.setOperation = op.attributes().getAttrString("set_operation");
            this.validateIndices = op.attributes().getAttrBool("validate_indices");
            this.T = op.attributes().getAttrType("T");
        }
    }

    public static class Options {
        private Boolean validateIndices;

        private Options() {
        }

        public Options validateIndices(Boolean validateIndices) {
            this.validateIndices = validateIndices;
            return this;
        }
    }
}

