/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

@OpMetadata(opType="BoostedTreesAggregateStats", inputsClass=Inputs.class)
public final class BoostedTreesAggregateStats
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "BoostedTreesAggregateStats";
    private Output<TFloat32> statsSummary;

    public BoostedTreesAggregateStats(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.statsSummary = operation.output(outputIdx++);
    }

    public static BoostedTreesAggregateStats create(Scope scope, Operand<TInt32> nodeIds, Operand<TFloat32> gradients, Operand<TFloat32> hessians, Operand<TInt32> feature, Long maxSplits, Long numBuckets) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(nodeIds.asOutput());
        opBuilder.addInput(gradients.asOutput());
        opBuilder.addInput(hessians.asOutput());
        opBuilder.addInput(feature.asOutput());
        opBuilder.setAttr("max_splits", maxSplits);
        opBuilder.setAttr("num_buckets", numBuckets);
        return new BoostedTreesAggregateStats(opBuilder.build());
    }

    public Output<TFloat32> statsSummary() {
        return this.statsSummary;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.statsSummary;
    }

    @OpInputsMetadata(outputsClass=BoostedTreesAggregateStats.class)
    public static class Inputs
    extends RawOpInputs<BoostedTreesAggregateStats> {
        public final Operand<TInt32> nodeIds;
        public final Operand<TFloat32> gradients;
        public final Operand<TFloat32> hessians;
        public final Operand<TInt32> feature;
        public final long maxSplits;
        public final long numBuckets;

        public Inputs(GraphOperation op) {
            super(new BoostedTreesAggregateStats(op), op, Arrays.asList("max_splits", "num_buckets"));
            int inputIndex = 0;
            this.nodeIds = op.input(inputIndex++);
            this.gradients = op.input(inputIndex++);
            this.hessians = op.input(inputIndex++);
            this.feature = op.input(inputIndex++);
            this.maxSplits = op.attributes().getAttrInt("max_splits");
            this.numBuckets = op.attributes().getAttrInt("num_buckets");
        }
    }
}

