/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Iterator;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.op.Scope;
import org.tensorflow.op.core.StatefulPartitionedCall;
import org.tensorflow.op.core.StatelessPartitionedCall;
import org.tensorflow.types.family.TType;

public interface PartitionedCall
extends Iterable<Operand<TType>> {
    public static PartitionedCall create(Scope scope, Iterable<Operand<?>> args, List<Class<? extends TType>> Tout, ConcreteFunction f, Options ... options) {
        boolean isStateful = false;
        if (f.isStateful()) {
            isStateful = true;
        }
        if (isStateful) {
            return StatefulPartitionedCall.create(scope, args, Tout, f, options);
        }
        return StatelessPartitionedCall.create(scope, args, Tout, f, options);
    }

    public static Options config(String config) {
        return new Options().config(config);
    }

    public static Options configProto(String configProto) {
        return new Options().configProto(configProto);
    }

    public static Options executorType(String executorType) {
        return new Options().executorType(executorType);
    }

    public List<Output<?>> output();

    @Override
    public Iterator<Operand<TType>> iterator();

    public static class Options {
        String config;
        String configProto;
        String executorType;

        private Options() {
        }

        public Options config(String config) {
            this.config = config;
            return this;
        }

        public Options configProto(String configProto) {
            this.configProto = configProto;
            return this;
        }

        public Options executorType(String executorType) {
            this.executorType = executorType;
            return this;
        }
    }
}

