/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.function.Consumer;
import org.tensorflow.RawTensor;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.Shaped;
import org.tensorflow.ndarray.buffer.ByteDataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

public interface Tensor
extends Shaped,
AutoCloseable {
    public static <T extends TType> T of(Class<T> type, Shape shape) {
        return Tensor.of(type, shape, -1L);
    }

    public static <T extends TType> T of(Class<T> type, Shape shape, long size) {
        RawTensor tensor = RawTensor.allocate(type, shape, size);
        try {
            return (T)tensor.asTypedTensor();
        }
        catch (Exception e) {
            tensor.close();
            throw e;
        }
    }

    public static <T extends TType> T of(Class<T> type, Shape shape, Consumer<T> dataInitializer) {
        return Tensor.of(type, shape, -1L, dataInitializer);
    }

    public static <T extends TType> T of(Class<T> type, Shape shape, long size, Consumer<T> dataInitializer) {
        T tensor = Tensor.of(type, shape, size);
        try {
            dataInitializer.accept(tensor);
            return tensor;
        }
        catch (Exception t) {
            tensor.close();
            throw t;
        }
    }

    public static <T extends TType> T of(Class<T> type, Shape shape, ByteDataBuffer rawData) {
        return (T)Tensor.of(type, shape, rawData.size(), t -> rawData.copyTo((DataBuffer)t.asRawTensor().data(), rawData.size()));
    }

    public DataType dataType();

    public long numBytes();

    @Override
    public Shape shape();

    public RawTensor asRawTensor();

    default public boolean isSparse() {
        return false;
    }

    @Override
    public void close();
}

