/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;

@OpMetadata(opType="InfeedEnqueueTuple", inputsClass=Inputs.class)
public final class InfeedEnqueueTuple
extends RawOp {
    public static final String OP_NAME = "InfeedEnqueueTuple";

    public InfeedEnqueueTuple(Operation operation) {
        super(operation, OP_NAME);
    }

    public static InfeedEnqueueTuple create(Scope scope, Iterable<Operand<?>> inputs, List<Shape> shapes, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(inputs));
        Shape[] shapesArray = new Shape[shapes.size()];
        for (int i = 0; i < shapesArray.length; ++i) {
            shapesArray[i] = shapes.get(i);
        }
        opBuilder.setAttr("shapes", shapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.layouts != null) {
                    long[] layoutsArray = new long[opts.layouts.size()];
                    for (int i = 0; i < layoutsArray.length; ++i) {
                        layoutsArray[i] = opts.layouts.get(i);
                    }
                    opBuilder.setAttr("layouts", layoutsArray);
                }
                if (opts.deviceOrdinal == null) continue;
                opBuilder.setAttr("device_ordinal", opts.deviceOrdinal);
            }
        }
        return new InfeedEnqueueTuple(opBuilder.build());
    }

    public static Options layouts(List<Long> layouts) {
        return new Options().layouts(layouts);
    }

    public static Options layouts(Long ... layouts) {
        return new Options().layouts(layouts);
    }

    public static Options deviceOrdinal(Long deviceOrdinal) {
        return new Options().deviceOrdinal(deviceOrdinal);
    }

    @OpInputsMetadata(outputsClass=InfeedEnqueueTuple.class)
    public static class Inputs
    extends RawOpInputs<InfeedEnqueueTuple> {
        public final Iterable<Operand<?>> inputs;
        public final DataType[] dtypes;
        public final Shape[] shapes;
        public final long[] layouts;
        public final long deviceOrdinal;

        public Inputs(GraphOperation op) {
            super(new InfeedEnqueueTuple(op), op, Arrays.asList("dtypes", "shapes", "layouts", "device_ordinal"));
            int inputIndex = 0;
            int inputsLength = op.inputListLength("inputs");
            this.inputs = Arrays.asList((Operand[])op.inputList(inputIndex, inputsLength));
            inputIndex += inputsLength;
            this.dtypes = op.attributes().getAttrTypeList("dtypes");
            this.shapes = op.attributes().getAttrShapeList("shapes");
            this.layouts = op.attributes().getAttrIntList("layouts");
            this.deviceOrdinal = op.attributes().getAttrInt("device_ordinal");
        }
    }

    public static class Options {
        private List<Long> layouts;
        private Long deviceOrdinal;

        private Options() {
        }

        public Options layouts(List<Long> layouts) {
            this.layouts = layouts;
            return this;
        }

        public Options layouts(Long ... layouts) {
            this.layouts = Arrays.asList(layouts);
            return this;
        }

        public Options deviceOrdinal(Long deviceOrdinal) {
            this.deviceOrdinal = deviceOrdinal;
            return this;
        }
    }
}

