/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.summary;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Tensor;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="ImageSummary", inputsClass=Inputs.class)
public final class ImageSummary
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "ImageSummary";
    private Output<TString> summary;

    public ImageSummary(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.summary = operation.output(outputIdx++);
    }

    public static ImageSummary create(Scope scope, Operand<TString> tag, Operand<? extends TNumber> tensor, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(tag.asOutput());
        opBuilder.addInput(tensor.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.maxImages != null) {
                    opBuilder.setAttr("max_images", opts.maxImages);
                }
                if (opts.badColor == null) continue;
                opBuilder.setAttr("bad_color", opts.badColor);
            }
        }
        return new ImageSummary(opBuilder.build());
    }

    public static Options maxImages(Long maxImages) {
        return new Options().maxImages(maxImages);
    }

    public static Options badColor(Tensor badColor) {
        return new Options().badColor(badColor);
    }

    public Output<TString> summary() {
        return this.summary;
    }

    @Override
    public Output<TString> asOutput() {
        return this.summary;
    }

    @OpInputsMetadata(outputsClass=ImageSummary.class)
    public static class Inputs
    extends RawOpInputs<ImageSummary> {
        public final Operand<TString> tag;
        public final Operand<? extends TNumber> tensor;
        public final long maxImages;
        public final DataType T;
        public final Tensor badColor;

        public Inputs(GraphOperation op) {
            super(new ImageSummary(op), op, Arrays.asList("max_images", "T", "bad_color"));
            int inputIndex = 0;
            this.tag = op.input(inputIndex++);
            this.tensor = op.input(inputIndex++);
            this.maxImages = op.attributes().getAttrInt("max_images");
            this.T = op.attributes().getAttrType("T");
            this.badColor = op.attributes().getAttrTensor("bad_color");
        }
    }

    public static class Options {
        private Long maxImages;
        private Tensor badColor;

        private Options() {
        }

        public Options maxImages(Long maxImages) {
            this.maxImages = maxImages;
            return this;
        }

        public Options badColor(Tensor badColor) {
            this.badColor = badColor;
            return this;
        }
    }
}

