/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="GRUBlockCellGrad", inputsClass=Inputs.class)
public final class GRUBlockCellGrad<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "GRUBlockCellGrad";
    private Output<T> dX;
    private Output<T> dHPrev;
    private Output<T> dCBar;
    private Output<T> dRBarUBar;

    public GRUBlockCellGrad(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.dX = operation.output(outputIdx++);
        this.dHPrev = operation.output(outputIdx++);
        this.dCBar = operation.output(outputIdx++);
        this.dRBarUBar = operation.output(outputIdx++);
    }

    public static <T extends TNumber> GRUBlockCellGrad<T> create(Scope scope, Operand<T> x, Operand<T> hPrev, Operand<T> wRu, Operand<T> wC, Operand<T> bRu, Operand<T> bC, Operand<T> r, Operand<T> u, Operand<T> c, Operand<T> dH) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(x.asOutput());
        opBuilder.addInput(hPrev.asOutput());
        opBuilder.addInput(wRu.asOutput());
        opBuilder.addInput(wC.asOutput());
        opBuilder.addInput(bRu.asOutput());
        opBuilder.addInput(bC.asOutput());
        opBuilder.addInput(r.asOutput());
        opBuilder.addInput(u.asOutput());
        opBuilder.addInput(c.asOutput());
        opBuilder.addInput(dH.asOutput());
        return new GRUBlockCellGrad<T>(opBuilder.build());
    }

    public Output<T> dX() {
        return this.dX;
    }

    public Output<T> dHPrev() {
        return this.dHPrev;
    }

    public Output<T> dCBar() {
        return this.dCBar;
    }

    public Output<T> dRBarUBar() {
        return this.dRBarUBar;
    }

    @OpInputsMetadata(outputsClass=GRUBlockCellGrad.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<GRUBlockCellGrad<T>> {
        public final Operand<T> x;
        public final Operand<T> hPrev;
        public final Operand<T> wRu;
        public final Operand<T> wC;
        public final Operand<T> bRu;
        public final Operand<T> bC;
        public final Operand<T> r;
        public final Operand<T> u;
        public final Operand<T> c;
        public final Operand<T> dH;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new GRUBlockCellGrad(op), op, Arrays.asList("T"));
            int inputIndex = 0;
            this.x = op.input(inputIndex++);
            this.hPrev = op.input(inputIndex++);
            this.wRu = op.input(inputIndex++);
            this.wC = op.input(inputIndex++);
            this.bRu = op.input(inputIndex++);
            this.bC = op.input(inputIndex++);
            this.r = op.input(inputIndex++);
            this.u = op.input(inputIndex++);
            this.c = op.input(inputIndex++);
            this.dH = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
        }
    }
}

